/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;

public class TerminalStorageIngredientCraftingOptionsPacket
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private NBTTagCompound data;
    @CodecField
    private boolean reset;
    @CodecField
    private boolean firstChannel;

    public TerminalStorageIngredientCraftingOptionsPacket() {
    }

    public <T> TerminalStorageIngredientCraftingOptionsPacket(String tabId, int channel, List<HandlerWrappedTerminalCraftingOption<T>> craftingOptions, boolean reset, boolean firstChannel) {
        this.tabId = tabId;
        this.channel = channel;
        this.data = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (HandlerWrappedTerminalCraftingOption<T> option : craftingOptions) {
            list.func_74742_a((NBTBase)HandlerWrappedTerminalCraftingOption.serialize(option));
        }
        this.data.func_74782_a("craftingOptions", (NBTBase)list);
        this.reset = reset;
        this.firstChannel = firstChannel;
    }

    public boolean isAsync() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerTerminalStorage) {
            ContainerTerminalStorage container = (ContainerTerminalStorage)player.field_71070_bA;
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            IngredientComponent ingredientComponent = tab.getIngredientComponent();
            NBTTagList list = this.data.func_150295_c("craftingOptions", 10);
            ArrayList craftingOptions = Lists.newArrayListWithExpectedSize((int)list.func_74745_c());
            for (int i = 0; i < list.func_74745_c(); ++i) {
                HandlerWrappedTerminalCraftingOption option = HandlerWrappedTerminalCraftingOption.deserialize(ingredientComponent, list.func_150305_b(i));
                craftingOptions.add(option);
            }
            tab.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
            if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                tabCrafting.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
            }
            container.refreshChannelStrings();
        }
    }

    public void actionServer(World world, EntityPlayerMP player) {
    }
}

