/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.CraftingJobStartException;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorage;
import org.cyclops.integratedterminals.proxy.guiprovider.GuiProviders;

public class ContainerTerminalStorageCraftingPlan
extends ExtendedInventoryContainer {
    public static final int BUTTON_START = 1;
    private static final ExecutorService WORKER_POOL = Executors.newFixedThreadPool(GeneralConfig.craftingPlannerThreads);
    private final World world;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private final CraftingOptionGuiData craftingOptionGuiData;
    private final int craftingPlanNotifierId;
    private boolean calculatedCraftingPlan;
    private ITerminalCraftingPlan craftingPlan;

    public ContainerTerminalStorageCraftingPlan(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, CraftingOptionGuiData craftingOptionGuiData) {
        super(player.field_71071_by, GuiProviders.GUI_TERMINAL_STORAGE_CRAFTNG_PLAN);
        this.world = target.getCenter().getPos().getWorld();
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.craftingOptionGuiData = craftingOptionGuiData;
        this.craftingPlanNotifierId = this.getNextValueId();
        this.putButtonAction(1, (buttonId, container) -> this.startCraftingJob());
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.player.field_70170_p.field_72995_K && !this.calculatedCraftingPlan) {
            this.calculatedCraftingPlan = true;
            this.updateCraftingPlan();
        }
    }

    public int getCraftingPlanNotifierId() {
        return this.craftingPlanNotifierId;
    }

    protected void updateCraftingPlan() {
        if (GeneralConfig.craftingPlannerEnableMultithreading) {
            WORKER_POOL.execute(this::updateCraftingPlanJob);
        } else {
            this.updateCraftingPlanJob();
        }
    }

    protected void updateCraftingPlanJob() {
        HandlerWrappedTerminalCraftingOption craftingOptionWrapper = this.craftingOptionGuiData.getCraftingOption();
        INetwork network = NetworkHelpers.getNetwork((PartPos)this.target.getCenter());
        this.setCraftingPlan(craftingOptionWrapper.getHandler().calculateCraftingPlan(network, this.craftingOptionGuiData.getChannel(), craftingOptionWrapper.getCraftingOption(), this.craftingOptionGuiData.getAmount()));
    }

    protected void setCraftingPlan(ITerminalCraftingPlan craftingPlan) {
        this.craftingPlan = craftingPlan;
        this.setValue(this.craftingPlanNotifierId, this.craftingOptionGuiData.getCraftingOption().getHandler().serializeCraftingPlan(this.craftingPlan));
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    private void startCraftingJob() {
        if (!this.world.field_72995_K) {
            INetwork network;
            if (this.craftingPlan != null && (network = NetworkHelpers.getNetwork((PartPos)PartPos.of((World)this.world, (BlockPos)this.craftingOptionGuiData.getPos(), (EnumFacing)this.craftingOptionGuiData.getSide()))) != null) {
                try {
                    this.craftingOptionGuiData.getCraftingOption().getHandler().startCraftingJob(network, this.craftingOptionGuiData.getChannel(), this.craftingPlan, (EntityPlayerMP)this.player);
                    IntegratedTerminals._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.TERMINAL_STORAGE, (Object)Pair.of((Object)this.craftingOptionGuiData.getSide(), (Object)new ContainerTerminalStorage.InitTabData(this.craftingOptionGuiData.getTabName(), this.craftingOptionGuiData.getChannel())));
                    BlockPos pos = this.craftingOptionGuiData.getPos();
                    this.player.openGui((Object)IntegratedTerminals._instance, GuiProviders.ID_GUI_TERMINAL_STORAGE_INIT, this.world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                catch (CraftingJobStartException e) {
                    this.craftingPlan.setError(e.getUnlocalizedError());
                    this.setCraftingPlan(this.craftingPlan);
                }
            }
        } else {
            IntegratedTerminals._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.TERMINAL_STORAGE, (Object)Pair.of((Object)this.craftingOptionGuiData.getSide(), (Object)new ContainerTerminalStorage.InitTabData(this.craftingOptionGuiData.getTabName(), this.craftingOptionGuiData.getChannel())));
        }
    }
}

