/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTab;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabServer;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabCommonLoadSlotsEvent;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabs;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.part.PartTypeTerminalStorage;

public class ContainerTerminalStorage
extends ExtendedInventoryContainer {
    private final World world;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private final PartTypeTerminalStorage.State partState;
    private final Map<String, ITerminalStorageTabClient<?>> tabsClient;
    private final Map<String, ITerminalStorageTabServer> tabsServer;
    private final Map<String, ITerminalStorageTabCommon> tabsCommon;
    private final Map<String, List<Triple<Slot, Integer, Integer>>> tabSlots;
    private int selectedTabIndexValueId;
    private int selectedChannelValueId;
    private boolean serverTabsInitialized;
    private final List<String> channelStrings;
    private String channelAllLabel;
    private static final TerminalStorageState GLOBAL_PLAYER_STATE = new TerminalStorageState();

    public ContainerTerminalStorage(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super(player.field_71071_by, (IGuiContainerProvider)partType);
        this.partState = (PartTypeTerminalStorage.State)partContainer.getPartState(target.getCenter().getSide());
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.tabsClient = Maps.newLinkedHashMap();
        this.tabsServer = Maps.newLinkedHashMap();
        this.tabsCommon = Maps.newLinkedHashMap();
        this.tabSlots = Maps.newHashMap();
        this.selectedTabIndexValueId = this.getNextValueId();
        this.selectedChannelValueId = this.getNextValueId();
        this.serverTabsInitialized = false;
        this.addPlayerInventory(player.field_71071_by, 31, 143);
        this.world = player.field_70170_p;
        this.channelAllLabel = L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.channel_all", (Object[])new Object[0]);
        this.channelStrings = Lists.newArrayList((Object[])new String[]{this.channelAllLabel});
        for (ITerminalStorageTab tab : TerminalStorageTabs.REGISTRY.getTabs()) {
            ITerminalStorageTabCommon commonTab;
            String id = tab.getName().toString();
            if (this.world.field_72995_K) {
                this.tabsClient.put(id, tab.createClientTab(this, player, target));
            } else {
                this.tabsServer.put(id, tab.createServerTab(this, player, target));
            }
            if ((commonTab = tab.createCommonTab(this, player, target)) == null) continue;
            this.tabsCommon.put(id, commonTab);
            int slotStartIndex = this.field_75151_b.size();
            List<Slot> slots = commonTab.loadSlots((Container)this, slotStartIndex, player, this.partState);
            TerminalStorageTabCommonLoadSlotsEvent loadSlotsEvent = new TerminalStorageTabCommonLoadSlotsEvent(commonTab, this, slots);
            MinecraftForge.EVENT_BUS.post((Event)loadSlotsEvent);
            slots = loadSlotsEvent.getSlots();
            this.tabSlots.put(id, slots.stream().map(slot -> Triple.of((Object)slot, (Object)slot.field_75223_e, (Object)slot.field_75221_f)).collect(Collectors.toList()));
            for (Slot slot2 : slots) {
                if (slot2.field_75222_d != 0) continue;
                this.func_75146_a(slot2);
            }
        }
        for (ITerminalStorageTabCommon tabCommon : this.tabsCommon.values()) {
            this.disableSlots(tabCommon.getName().toString());
        }
        if (player.field_70170_p.field_72995_K) {
            TerminalStorageState state = this.getGuiState();
            this.setSelectedTab(state.hasTab() ? state.getTab() : (this.getTabsClient().size() > 0 ? ((ITerminalStorageTabClient)Iterables.getFirst(this.getTabsClient().values(), null)).getName().toString() : null));
            this.setSelectedChannel(-1);
        } else {
            this.setSelectedTab(null);
            this.setSelectedChannel(-1);
        }
    }

    public ContainerTerminalStorage(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, InitTabData initTabData) {
        this(player, target, partContainer, partType);
        this.setSelectedTab(initTabData.getTabName());
        this.setSelectedChannel(initTabData.getChannel());
    }

    public TerminalStorageState getGuiState() {
        return GLOBAL_PLAYER_STATE;
    }

    public int getNextValueId() {
        return super.getNextValueId();
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.serverTabsInitialized) {
            for (ITerminalStorageTabServer iTerminalStorageTabServer : this.tabsServer.values()) {
                iTerminalStorageTabServer.init();
            }
            this.serverTabsInitialized = true;
        }
        for (ITerminalStorageTabCommon iTerminalStorageTabCommon : this.tabsCommon.values()) {
            iTerminalStorageTabCommon.onUpdate((Container)this, this.player, this.partState);
        }
        ITerminalStorageTabServer activeServerTab = this.getTabServer(this.getSelectedTab());
        if (activeServerTab != null) {
            activeServerTab.updateActive();
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.world.field_72995_K && this.serverTabsInitialized) {
            for (ITerminalStorageTabServer tab : this.tabsServer.values()) {
                tab.deInit();
            }
        }
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public PartTypeTerminalStorage.State getPartState() {
        return this.partState;
    }

    public PartTypeTerminalStorage getPartType() {
        return (PartTypeTerminalStorage)this.partType;
    }

    protected int getSizeInventory() {
        return this.field_75151_b.size() - this.player.field_71071_by.field_70462_a.size();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return PartHelpers.canInteractWith((PartTarget)this.getTarget(), (EntityPlayer)this.player, (IPartContainer)this.partContainer);
    }

    public List<Triple<Slot, Integer, Integer>> getTabSlots(String tabName) {
        List<Triple<Slot, Integer, Integer>> slots = this.tabSlots.get(tabName);
        if (slots == null) {
            return Collections.emptyList();
        }
        return slots;
    }

    protected void enableSlots(String tabName) {
        List<Triple<Slot, Integer, Integer>> slots = this.getTabSlots(tabName);
        if (slots != null) {
            for (Triple<Slot, Integer, Integer> slot : slots) {
                ((Slot)slot.getLeft()).field_75223_e = (Integer)slot.getMiddle();
                ((Slot)slot.getLeft()).field_75221_f = (Integer)slot.getRight();
            }
        }
    }

    protected void disableSlots(String tabName) {
        List<Triple<Slot, Integer, Integer>> slots = this.getTabSlots(tabName);
        if (slots != null) {
            for (Triple<Slot, Integer, Integer> slot : slots) {
                ((Slot)slot.getLeft()).field_75223_e = Integer.MIN_VALUE;
                ((Slot)slot.getLeft()).field_75221_f = Integer.MIN_VALUE;
            }
        }
    }

    public void setSelectedTab(@Nullable String selectedTab) {
        this.disableSlots(this.getSelectedTab());
        if (this.player.field_70170_p.field_72995_K) {
            this.getGuiState().setTab(selectedTab);
        }
        if (selectedTab != null) {
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.selectedTabIndexValueId, (String)selectedTab);
        }
        this.enableSlots(this.getSelectedTab());
    }

    @Nullable
    public String getSelectedTab() {
        return ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.selectedTabIndexValueId);
    }

    public void setSelectedChannel(int selectedChannel) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.selectedChannelValueId, (int)selectedChannel);
        this.refreshChannelStrings();
    }

    public int getSelectedChannel() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.selectedChannelValueId);
    }

    @Nullable
    public ITerminalStorageTabClient getTabClient(String id) {
        return this.tabsClient.get(id);
    }

    @Nullable
    public ITerminalStorageTabServer getTabServer(String id) {
        return this.tabsServer.get(id);
    }

    @Nullable
    public ITerminalStorageTabCommon getTabCommon(String id) {
        return this.tabsCommon.get(id);
    }

    public int getTabsClientCount() {
        return this.getTabsClient().size();
    }

    public Map<String, ITerminalStorageTabClient<?>> getTabsClient() {
        LinkedHashMap tabs = Maps.newLinkedHashMap();
        for (Map.Entry<String, ITerminalStorageTabClient<?>> entry : this.tabsClient.entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            tabs.put(entry.getKey(), entry.getValue());
        }
        return tabs;
    }

    public Map<String, ITerminalStorageTabCommon> getTabsCommon() {
        LinkedHashMap tabs = Maps.newLinkedHashMap();
        for (Map.Entry<String, ITerminalStorageTabCommon> entry : this.tabsCommon.entrySet()) {
            tabs.put(entry.getKey(), entry.getValue());
        }
        return tabs;
    }

    public Map<String, ITerminalStorageTabServer> getTabsServer() {
        return this.tabsServer;
    }

    public List<String> getChannelStrings() {
        return this.channelStrings;
    }

    public void refreshChannelStrings() {
        this.channelStrings.clear();
        this.channelStrings.add(this.channelAllLabel);
        ITerminalStorageTabClient<?> tab = this.tabsClient.get(this.getSelectedTab());
        if (tab != null) {
            for (int channel : tab.getChannels()) {
                this.channelStrings.add(String.valueOf(channel));
            }
        }
    }

    public static class InitTabData {
        private final String tabName;
        private final int channel;

        public InitTabData(String tabName, int channel) {
            this.tabName = tabName;
            this.channel = channel;
        }

        public String getTabName() {
            return this.tabName;
        }

        public int getChannel() {
            return this.channel;
        }
    }
}

