/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class ContainerTerminalCraftingJobs
extends ExtendedInventoryContainer {
    private final World world;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private final INetwork network;
    private final int valueIdCraftingJobs;
    private long lastUpdate;
    private List<HandlerWrappedTerminalCraftingPlan> craftingJobs;

    public ContainerTerminalCraftingJobs(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super(player.field_71071_by, (IGuiContainerProvider)partType);
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.world = player.field_70170_p;
        this.network = NetworkHelpers.getNetwork((PartPos)target.getCenter());
        this.lastUpdate = 0L;
        this.craftingJobs = Lists.newArrayList();
        this.valueIdCraftingJobs = this.getNextValueId();
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public int getChannel() {
        return -1;
    }

    public int getValueIdCraftingJobs() {
        return this.valueIdCraftingJobs;
    }

    public List<HandlerWrappedTerminalCraftingPlan> getCraftingJobs() {
        return this.craftingJobs;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.world.field_72995_K && this.lastUpdate < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis() + (long)GeneralConfig.guiTerminalCraftingJobsUpdateFrequency;
            int channel = this.getChannel();
            this.craftingJobs = Lists.newArrayList();
            for (ITerminalStorageTabIngredientCraftingHandler iTerminalStorageTabIngredientCraftingHandler : TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandlers()) {
                for (ITerminalCraftingPlan craftingJob : iTerminalStorageTabIngredientCraftingHandler.getCraftingJobs(this.network, channel)) {
                    this.craftingJobs.add(new HandlerWrappedTerminalCraftingPlan(iTerminalStorageTabIngredientCraftingHandler, craftingJob));
                }
            }
            NBTTagList tagList = new NBTTagList();
            for (HandlerWrappedTerminalCraftingPlan craftingJob : this.craftingJobs) {
                tagList.func_74742_a((NBTBase)HandlerWrappedTerminalCraftingPlan.serialize(craftingJob));
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("craftingJobs", (NBTBase)tagList);
            this.setValue(this.valueIdCraftingJobs, nBTTagCompound);
        }
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        super.onUpdate(valueId, value);
        if (valueId == this.valueIdCraftingJobs) {
            NBTTagList tagList = value.func_150295_c("craftingJobs", 10);
            this.craftingJobs = Lists.newArrayListWithExpectedSize((int)tagList.func_74745_c());
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.craftingJobs.add(HandlerWrappedTerminalCraftingPlan.deserialize(tagList.func_150305_b(i)));
            }
        }
    }
}

