/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.crafting;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class HandlerWrappedTerminalCraftingOption<T> {
    private final ITerminalStorageTabIngredientCraftingHandler handler;
    private final ITerminalCraftingOption<T> craftingOption;

    public HandlerWrappedTerminalCraftingOption(ITerminalStorageTabIngredientCraftingHandler handler, ITerminalCraftingOption<T> craftingOption) {
        this.handler = handler;
        this.craftingOption = craftingOption;
    }

    public ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return this.handler;
    }

    public ITerminalCraftingOption<T> getCraftingOption() {
        return this.craftingOption;
    }

    public static <T> NBTTagCompound serialize(HandlerWrappedTerminalCraftingOption<T> craftingOption) {
        ITerminalStorageTabIngredientCraftingHandler handler = craftingOption.getHandler();
        NBTTagCompound tag = handler.serializeCraftingOption(craftingOption.getCraftingOption());
        tag.func_74778_a("craftingOptionHandler", handler.getId().toString());
        return tag;
    }

    public static <T, M> HandlerWrappedTerminalCraftingOption<T> deserialize(IngredientComponent<T, M> ingredientComponent, NBTTagCompound tag) {
        if (!tag.func_150297_b("craftingOptionHandler", 8)) {
            throw new IllegalArgumentException("Could not find a craftingOptionHandler entry in the given tag");
        }
        String handlerId = tag.func_74779_i("craftingOptionHandler");
        ITerminalStorageTabIngredientCraftingHandler handler = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(new ResourceLocation(handlerId));
        Object craftingOption = handler.deserializeCraftingOption(ingredientComponent, tag);
        return new HandlerWrappedTerminalCraftingOption<T>(handler, craftingOption);
    }
}

