/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.client.gui.GuiButtonSort;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonSort<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, ITerminalStorageTabCommon, GuiButtonSort> {
    private final IIngredientInstanceSorter<T> instanceSorter;
    private final TerminalStorageState state;
    private final String buttonName;
    private Comparator<T> effectiveSorter;
    private boolean active;
    private boolean descending;

    public TerminalButtonSort(IIngredientInstanceSorter<T> instanceSorter, TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.instanceSorter = instanceSorter;
        this.state = state;
        this.buttonName = "sort_" + instanceSorter.getTranslationKey();
        if (state.hasButton(clientTab.getName().toString(), this.buttonName)) {
            NBTTagCompound data = (NBTTagCompound)state.getButton(clientTab.getName().toString(), this.buttonName);
            this.active = data.func_74767_n("active");
            this.descending = data.func_74767_n("descending");
        } else {
            this.active = false;
            this.descending = true;
        }
        this.updateSorter();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiButtonSort createButton(int x, int y) {
        return new GuiButtonSort(0, x, y, this.instanceSorter.getIcon(), this.active, this.descending);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(TerminalStorageTabIngredientComponentClient<T, ?> clientTab, ITerminalStorageTabCommon commonTab, GuiButtonSort guiButton, int channel, int mouseButton) {
        if (mouseButton == 0) {
            if (this.active) {
                if (this.descending) {
                    this.descending = false;
                } else {
                    this.active = false;
                }
            } else {
                this.active = true;
                this.descending = true;
            }
        } else {
            this.active = false;
            this.descending = true;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74757_a("active", this.active);
        data.func_74757_a("descending", this.descending);
        this.state.setButton(clientTab.getName().toString(), this.buttonName, (NBTBase)data);
        this.updateSorter();
        clientTab.resetFilteredIngredientsViews(channel);
    }

    protected void updateSorter() {
        this.effectiveSorter = this.active ? (this.descending ? this.instanceSorter.reversed() : this.instanceSorter) : null;
    }

    @Override
    public String getTranslationKey() {
        return this.instanceSorter.getTranslationKey();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(EntityPlayer player, ITooltipFlag tooltipFlag, List<String> lines) {
        this.instanceSorter.getTooltip(player, tooltipFlag, lines);
        if (this.active) {
            lines.add(TextFormatting.ITALIC + L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.sort.order.label", (Object[])new Object[]{L10NHelpers.localize((String)(this.descending ? "gui.integratedterminals.terminal_storage.sort.order.descending" : "gui.integratedterminals.terminal_storage.sort.order.ascending"), (Object[])new Object[0])}));
        } else {
            lines.add(TextFormatting.ITALIC + L10NHelpers.localize((String)"general.cyclopscore.info.disabled", (Object[])new Object[0]));
        }
    }

    @Nullable
    public Comparator<T> getEffectiveSorter() {
        return this.effectiveSorter;
    }
}

