/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container.component;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.client.gui.component.GuiScrollBar;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.lwjgl.opengl.GL11;

public class GuiCraftingPlan
extends Gui {
    private static final int ELEMENT_WIDTH = 221;
    private static final int ELEMENT_HEIGHT = 16;
    private static final int ELEMENT_HEIGHT_TOTAL = 18;
    protected static final int TICK_DELAY = 30;
    private final GuiContainer parentGui;
    private final int guiLeft;
    private final int guiTop;
    private final int x;
    private final int y;
    private final List<Element> elements;
    private final List<Element> visibleElements;
    private final boolean valid;
    private final GuiScrollBar scrollBar;
    private final String label;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;
    private int firstRow;

    public GuiCraftingPlan(GuiContainer parentGui, ITerminalCraftingPlan<?> craftingPlan, int guiLeft, int guiTop, int x, int y, int visibleRows) {
        this.parentGui = parentGui;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.x = x;
        this.y = y;
        this.elements = GuiCraftingPlan.getElements(craftingPlan);
        this.visibleElements = Lists.newArrayList(this.elements);
        this.valid = craftingPlan.getStatus().isValid();
        this.scrollBar = new GuiScrollBar(guiLeft + x + 227, guiTop + y + 0, 178, this::setFirstRow, visibleRows);
        this.scrollBar.setTotalRows(this.visibleElements.size() - 1);
        this.label = L10NHelpers.localize((String)craftingPlan.getUnlocalizedLabel(), (Object[])new Object[0]);
        this.tickDuration = craftingPlan.getTickDuration();
        this.channel = craftingPlan.getChannel();
        this.initiatorName = craftingPlan.getInitiatorName();
    }

    public void inheritVisualizationState(GuiCraftingPlan guiCraftingPlan) {
        float lastScroll = guiCraftingPlan.scrollBar.getCurrentScroll();
        this.scrollBar.scrollTo(lastScroll);
    }

    protected void refreshList() {
        this.visibleElements.clear();
        GuiCraftingPlan.addActiveElements(this.elements.get(0), this.visibleElements);
        this.scrollBar.setTotalRows(this.visibleElements.size());
    }

    protected static void addActiveElements(Element root, List<Element> elements) {
        if (root.isEnabled()) {
            elements.add(root);
            for (Element child : root.getChildren()) {
                GuiCraftingPlan.addActiveElements(child, elements);
            }
        }
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        this.scrollBar.drawCurrentScreen(mouseX, mouseY, partialTicks);
    }

    protected List<Element> getVisibleElements() {
        return this.visibleElements.subList(this.firstRow, Math.min(this.visibleElements.size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    protected int getAbsoluteElementIndent(Element element) {
        return element.getIndent() * 8;
    }

    public void drawGuiContainerLayer(int guiLeft, int guiTop, GuiTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int offsetY = 0;
        for (Element element : this.getVisibleElements()) {
            this.drawElement(element, this.getAbsoluteElementIndent(element), guiLeft + this.x, guiTop + this.y + offsetY, 221, 16, layer, partialTick, mouseX, mouseY);
            offsetY += 18;
        }
    }

    protected int getTick() {
        return (int)Minecraft.func_71410_x().field_71441_e.func_72820_D() / 30;
    }

    private void drawElement(Element element, int indent, int x, int y, int width, int height, GuiTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        if (layer == GuiTerminalStorage.DrawLayer.BACKGROUND) {
            GuiCraftingPlan.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height + 1), (int)element.getColor());
        }
        int xOriginal = x;
        x += indent;
        if (!element.getChildren().isEmpty() && layer == GuiTerminalStorage.DrawLayer.BACKGROUND) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Image image = element.getChildren().get(0).isEnabled() ? Images.ARROW_DOWN : Images.ARROW_RIGHT;
            image.draw((Gui)this, x, y);
        }
        x += 16;
        int tick = this.getTick();
        for (List<IPrototypedIngredient<?, ?>> alternatives : element.getOutputs()) {
            IPrototypedIngredient<?, ?> output = alternatives.get(tick % alternatives.size());
            IngredientComponent ingredientComponent = output.getComponent();
            long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
            ((IIngredientComponentTerminalStorageHandler)ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY)).drawInstance(output.getPrototype(), quantity, GuiHelpers.quantityToScaledString((long)quantity), this.parentGui, layer, partialTick, x, y, mouseX, mouseY, null);
            x += GuiHelpers.SLOT_SIZE_INNER;
        }
        x = xOriginal + width - 50;
        if (layer == GuiTerminalStorage.DrawLayer.BACKGROUND) {
            if (element.getStorageQuantity() > 0L) {
                GuiCraftingPlan.renderItem(new ItemStack((Block)Blocks.field_150486_ae), x, y, 0.45f);
                RenderHelpers.drawScaledString((FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.stored", (Object[])new Object[]{element.getStorageQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true);
                y += 8;
            }
            if (element.getCraftQuantity() > 0L) {
                GuiCraftingPlan.renderItem(new ItemStack(Blocks.field_150462_ai), x, y, 0.45f);
                RenderHelpers.drawScaledString((FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.crafting", (Object[])new Object[]{element.getCraftQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true);
                y += 8;
            }
            if (element.getMissingQuantity() > 0L) {
                GuiCraftingPlan.renderItem(new ItemStack(Blocks.field_180401_cv), x, y, 0.45f);
                RenderHelpers.drawScaledString((FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.missing", (Object[])new Object[]{element.getMissingQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true);
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GuiHelpers.renderTooltipOptional((GuiContainer)this.parentGui, (int)x, (int)y, (int)50, (int)GuiHelpers.SLOT_SIZE, (int)mouseX, (int)mouseY, () -> {
                String unlocalizedName = "gui.integratedterminals.craftingplan.status." + element.getStatus().name().toLowerCase(Locale.ENGLISH) + ".";
                return Optional.of(Lists.newArrayList((Object[])new String[]{L10NHelpers.localize((String)(unlocalizedName + "name"), (Object[])new Object[0]), L10NHelpers.localize((String)(unlocalizedName + "desc"), (Object[])new Object[0])}));
            });
        }
    }

    protected static void renderItem(ItemStack itemStack, int x, int y, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        RenderItemExtendedSlotCount renderItem = RenderItemExtendedSlotCount.getInstance();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        GL11.glEnable((int)2929);
        renderItem.func_180450_b(itemStack, 0, 0);
        renderItem.func_180453_a(Minecraft.func_71410_x().field_71466_p, itemStack, 0, 0, "");
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public static String getDurationString(long tickDuration) {
        long durationMs = tickDuration * 1000L / 20L;
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.duration", (Object[])new Object[]{DurationFormatUtils.formatDuration((long)durationMs, (String)"H:mm:ss", (boolean)true)});
    }

    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, this.label, this.guiLeft + this.x + 110 + 8, this.guiTop + this.y - 13, 0xFFFFFF);
        if (this.tickDuration >= 0L) {
            String durationString = GuiCraftingPlan.getDurationString(this.tickDuration);
            RenderHelpers.drawScaledString((FontRenderer)fontRenderer, (String)durationString, (int)(this.guiLeft + this.x + 200), (int)(this.guiTop + this.y - 14), (float)0.5f, (int)0xFFFFFF, (boolean)true);
        }
        if (this.channel != -1) {
            String channelString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", (Object[])new Object[]{this.channel});
            RenderHelpers.drawScaledString((FontRenderer)fontRenderer, (String)channelString, (int)(this.guiLeft + this.x + 200), (int)(this.guiTop + this.y - 8), (float)0.5f, (int)0xFFFFFF, (boolean)true);
        }
        if (this.initiatorName != null) {
            String initiatorString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.owner", (Object[])new Object[]{this.initiatorName});
            RenderHelpers.drawScaledString((FontRenderer)fontRenderer, (String)initiatorString, (int)(this.guiLeft + this.x - 4), (int)(this.guiTop + this.y - 14), (float)0.5f, (int)0xFFFFFF, (boolean)true);
        }
        this.drawGuiContainerLayer(this.guiLeft, this.guiTop, GuiTerminalStorage.DrawLayer.BACKGROUND, partialTicks, mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.drawGuiContainerLayer(0, 0, GuiTerminalStorage.DrawLayer.FOREGROUND, 0.0f, mouseX, mouseY);
    }

    public void handleMouseInput() throws IOException {
        this.scrollBar.handleMouseInput();
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        int offsetY = 0;
        for (Element element : this.getVisibleElements()) {
            int x = this.guiLeft + this.x + this.getAbsoluteElementIndent(element);
            int y = this.guiTop + this.y + offsetY;
            offsetY += 18;
            if (!RenderHelpers.isPointInRegion((Rectangle)new Rectangle(x, y, 221, 16), (Point)new Point(mouseX, mouseY))) continue;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            for (Element child : element.getChildren()) {
                child.setEnabled(!child.isEnabled());
            }
            this.refreshList();
            break;
        }
    }

    public static List<Element> getElements(ITerminalCraftingPlan<?> craftingPlan) {
        ArrayList elements = Lists.newArrayList();
        GuiCraftingPlan.addElements(null, 0, craftingPlan, elements);
        return elements;
    }

    protected static void addElements(@Nullable Element parent, int indent, ITerminalCraftingPlan<?> craftingPlan, List<Element> elements) {
        boolean valid = craftingPlan.getStatus().isValid() || !craftingPlan.getStorageIngredients().isEmpty() || !craftingPlan.getDependencies().isEmpty();
        Element currentElement = new Element(indent, craftingPlan.getOutputs().stream().map(Collections::singletonList).collect(Collectors.toList()), 0L, valid ? craftingPlan.getCraftingQuantity() : 0L, valid ? 0L : craftingPlan.getCraftingQuantity(), craftingPlan.getStatus().getColor(), craftingPlan.getStatus());
        if (parent != null) {
            parent.addChild(currentElement);
        }
        elements.add(currentElement);
        if (craftingPlan.getStatus() == TerminalCraftingJobStatus.PENDING_INPUTS) {
            for (List<IPrototypedIngredient<?, ?>> list : craftingPlan.getLastMissingIngredients()) {
                List<List<IPrototypedIngredient<?, ?>>> outputs = Collections.singletonList(list.stream().map(prototypedIngredient -> {
                    IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
                    Object instance = matcher.withQuantity(prototypedIngredient.getPrototype(), matcher.getQuantity(prototypedIngredient.getPrototype()) * craftingPlan.getCraftingQuantity());
                    return new PrototypedIngredient(prototypedIngredient.getComponent(), instance, prototypedIngredient.getCondition());
                }).collect(Collectors.toList()));
                elements.add(currentElement.addChild(new Element(indent + 1, outputs, 0L, 0L, craftingPlan.getCraftingQuantity(), TerminalCraftingJobStatus.INVALID.getColor(), TerminalCraftingJobStatus.INVALID)));
            }
        } else if (craftingPlan.getStatus() != TerminalCraftingJobStatus.CRAFTING) {
            for (IPrototypedIngredient iPrototypedIngredient : craftingPlan.getStorageIngredients()) {
                elements.add(currentElement.addChild(new Element(indent + 1, Collections.singletonList(Collections.singletonList(iPrototypedIngredient)), iPrototypedIngredient.getComponent().getMatcher().getQuantity(iPrototypedIngredient.getPrototype()), 0L, 0L, TerminalCraftingJobStatus.FINISHED.getColor(), TerminalCraftingJobStatus.FINISHED)));
            }
        }
        for (ITerminalCraftingPlan iTerminalCraftingPlan : craftingPlan.getDependencies()) {
            GuiCraftingPlan.addElements(currentElement, indent + 1, iTerminalCraftingPlan, elements);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public static class Element {
        private final int indent;
        private final List<List<IPrototypedIngredient<?, ?>>> outputs;
        private final long storageQuantity;
        private final long craftQuantity;
        private final long missingQuantity;
        private final int color;
        private final List<Element> children;
        private final TerminalCraftingJobStatus status;
        private boolean enabled;

        public Element(int indent, List<List<IPrototypedIngredient<?, ?>>> outputs, long storageQuantity, long craftQuantity, long missingQuantity, int color, TerminalCraftingJobStatus status) {
            this.indent = indent;
            this.outputs = outputs;
            this.storageQuantity = storageQuantity;
            this.craftQuantity = craftQuantity;
            this.missingQuantity = missingQuantity;
            this.color = color;
            this.status = status;
            this.children = Lists.newArrayList();
            this.enabled = true;
        }

        public int getIndent() {
            return this.indent;
        }

        public List<List<IPrototypedIngredient<?, ?>>> getOutputs() {
            return this.outputs;
        }

        public long getStorageQuantity() {
            return this.storageQuantity;
        }

        public long getCraftQuantity() {
            return this.craftQuantity;
        }

        public long getMissingQuantity() {
            return this.missingQuantity;
        }

        public int getColor() {
            return this.color;
        }

        public Element addChild(Element element) {
            this.children.add(element);
            return element;
        }

        public List<Element> getChildren() {
            return this.children;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public TerminalCraftingJobStatus getStatus() {
            return this.status;
        }
    }
}

