/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.component.GuiScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonExtended;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.GuiNumberField;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmount;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingPlanGuiPacket;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenPacket;

public class GuiTerminalStorageCraftingOptionAmount
extends GuiContainerExtended {
    public static int OUTPUT_SLOT_X = 135;
    public static int OUTPUT_SLOT_Y = 15;
    private final CraftingOptionGuiData craftingOptionGuiData;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private GuiNumberField numberField = null;
    private GuiScrollBar scrollBar;
    private int firstRow;
    private GuiButtonText nextButton;

    public GuiTerminalStorageCraftingOptionAmount(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, CraftingOptionGuiData craftingOptionGuiData) {
        super((ExtendedInventoryContainer)new ContainerTerminalStorageCraftingOptionAmount(player, target, partContainer, partType, craftingOptionGuiData));
        this.craftingOptionGuiData = craftingOptionGuiData;
        this.outputs = Lists.newArrayList();
        ITerminalCraftingOption<?> option = craftingOptionGuiData.getCraftingOption().getCraftingOption();
        for (IngredientComponent<?, ?> outputComponent : option.getOutputComponents()) {
            for (Object output : option.getOutputs(outputComponent)) {
                this.outputs.add((IPrototypedIngredient<?, ?>)new PrototypedIngredient(outputComponent, output, null));
            }
        }
    }

    protected ResourceLocation constructResourceLocation() {
        return new ResourceLocation("integratedterminals", this.getGuiTexture());
    }

    public String getGuiTexture() {
        return (String)IntegratedTerminals._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "crafting_option_amount.png";
    }

    public int getBaseXSize() {
        return 178;
    }

    public int getBaseYSize() {
        return 162;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.numberField = new GuiNumberField(0, Minecraft.func_71410_x().field_71466_p, this.field_147003_i + 25, this.field_147009_r + 36, 53, 14, true, true);
        this.numberField.setPositiveOnly(true);
        this.numberField.func_146203_f(5);
        this.numberField.setMaxValue(10000);
        this.numberField.setMinValue(1);
        this.numberField.func_146189_e(true);
        this.numberField.func_146193_g(0xFFFFFF);
        this.numberField.func_146205_d(true);
        this.numberField.func_146180_a("1");
        this.scrollBar = new GuiScrollBar(this.field_147003_i + 153, this.field_147009_r + 15, 54, this::setFirstRow, 3);
        this.scrollBar.setTotalRows(this.outputs.size() - 1);
        Object[] objectArray = new GuiButtonExtended[7];
        objectArray[0] = new GuiButtonChangeQuantity(0, this.field_147003_i + 5, this.field_147009_r + 10, 10);
        objectArray[1] = new GuiButtonChangeQuantity(1, this.field_147003_i + 5, this.field_147009_r + 55, -10);
        objectArray[2] = new GuiButtonChangeQuantity(2, this.field_147003_i + 48, this.field_147009_r + 10, 100);
        objectArray[3] = new GuiButtonChangeQuantity(3, this.field_147003_i + 48, this.field_147009_r + 55, -100);
        objectArray[4] = new GuiButtonChangeQuantity(4, this.field_147003_i + 91, this.field_147009_r + 10, 1000);
        objectArray[5] = new GuiButtonChangeQuantity(5, this.field_147003_i + 91, this.field_147009_r + 55, -1000);
        this.nextButton = new GuiButtonText(6, this.field_147003_i + 81, this.field_147009_r + 33, 50, 20, TextFormatting.BOLD + L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.step.next", (Object[])new Object[0]), true);
        objectArray[6] = this.nextButton;
        this.field_146292_n.addAll(Lists.newArrayList((Object[])objectArray));
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            if (keyCode == 1) {
                this.returnToTerminalStorage();
            } else if (keyCode == 156 || keyCode == 28) {
                this.calculateCraftingJob();
            } else if (!this.numberField.func_146201_a(typedChar, keyCode) && !this.numberField.func_146201_a(typedChar, keyCode)) {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    private void returnToTerminalStorage() {
        TerminalStorageIngredientOpenPacket.send(this.craftingOptionGuiData.getPos(), this.craftingOptionGuiData.getSide(), this.craftingOptionGuiData.getTabName(), this.craftingOptionGuiData.getChannel());
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.numberField.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public boolean requiresAction(int buttonId) {
        return true;
    }

    public void onButtonClick(int buttonId) {
        super.onButtonClick(buttonId);
        GuiButton button = (GuiButton)this.field_146292_n.get(buttonId);
        if (button instanceof GuiButtonChangeQuantity) {
            int diff = ((GuiButtonChangeQuantity)button).getDiff();
            this.setAmount(this.getAmount() + diff);
        } else if (button instanceof GuiButtonText) {
            this.calculateCraftingJob();
        }
    }

    private void calculateCraftingJob() {
        CraftingOptionGuiData craftingOptionData = CraftingOptionGuiData.copyWithAmount(this.craftingOptionGuiData, this.getAmount());
        IntegratedTerminals._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.CRAFTING_OPTION, (Object)Pair.of((Object)craftingOptionData.getSide(), craftingOptionData));
        IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingPlanGuiPacket(craftingOptionData));
    }

    protected <T, M> void drawInstance(IngredientComponent<T, M> ingredientComponent, T instance, int x, int y, GuiTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        long quantity = ingredientComponent.getMatcher().getQuantity(instance) * (long)this.getAmount();
        ((IIngredientComponentTerminalStorageHandler)ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY)).drawInstance(ingredientComponent.getMatcher().withQuantity(instance, quantity), quantity, GuiHelpers.quantityToScaledString((long)quantity), (GuiContainer)this, layer, partialTick, x, y, mouseX, mouseY, null);
    }

    private int getAmount() {
        try {
            return this.numberField.getInt();
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private void setAmount(int amount) {
        this.numberField.func_146180_a(Integer.toString(this.numberField.validateNumber(amount)));
    }

    protected void drawOutputSlots(int x, int y, float partialTicks, int mouseX, int mouseY, GuiTerminalStorage.DrawLayer layer) {
        int offsetY = OUTPUT_SLOT_Y;
        for (IPrototypedIngredient<?, ?> output : this.outputs.subList(this.firstRow, Math.min(this.outputs.size(), this.firstRow + this.scrollBar.getVisibleRows()))) {
            this.drawInstance(output.getComponent(), output.getPrototype(), x + OUTPUT_SLOT_X, y + offsetY, layer, partialTicks, mouseX, mouseY);
            offsetY += GuiHelpers.SLOT_SIZE;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.numberField.drawTextBox(Minecraft.func_71410_x(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        this.scrollBar.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.drawOutputSlots(this.field_147003_i, this.field_147009_r, partialTicks, mouseX - this.field_147003_i, mouseY - this.field_147009_r, GuiTerminalStorage.DrawLayer.BACKGROUND);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawOutputSlots(0, 0, 0.0f, mouseX, mouseY, GuiTerminalStorage.DrawLayer.FOREGROUND);
    }

    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawCurrentScreen(mouseX, mouseY, partialTicks);
        this.scrollBar.drawCurrentScreen(mouseX, mouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollBar.handleMouseInput();
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public class GuiButtonChangeQuantity
    extends GuiButtonExtended {
        private final int diff;

        public GuiButtonChangeQuantity(int id, int x, int y, int diff) {
            super(id, x, y, 40, 20, (diff < 0 ? "- " : "+ ") + Integer.toString(Math.abs(diff)), true);
            this.diff = diff;
        }

        protected void drawButtonInner(Minecraft minecraft, int i, int j, boolean mouseOver) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = 0xE0E0E0;
            if (!this.field_146124_l) {
                color = 0xA0A0A0;
            } else if (this.field_146123_n) {
                color = 0xFFFFA0;
            }
            this.func_73732_a(minecraft.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, color);
        }

        public int getDiff() {
            return this.diff;
        }
    }
}

