/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsPlan;
import org.cyclops.integratedterminals.network.packet.CancelCraftingJobPacket;
import org.cyclops.integratedterminals.network.packet.OpenCraftingJobsGuiPacket;

public class GuiTerminalCraftingJobsPlan
extends GuiContainerExtended {
    private final EntityPlayer player;
    @Nullable
    private GuiCraftingPlan guiCraftingPlan;

    public GuiTerminalCraftingJobsPlan(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, CraftingJobGuiData craftingPlanGuiData) {
        super((ExtendedInventoryContainer)new ContainerTerminalCraftingJobsPlan(player, target, partContainer, partType, craftingPlanGuiData));
        this.player = player;
    }

    protected ResourceLocation constructResourceLocation() {
        return new ResourceLocation("integratedterminals", this.getGuiTexture());
    }

    public String getGuiTexture() {
        return (String)IntegratedTerminals._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "crafting_plan.png";
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        ITerminalCraftingPlan craftingPlan = this.getContainer().getCraftingPlan();
        if (craftingPlan != null) {
            GuiCraftingPlan previousGuiCraftingPlan = this.guiCraftingPlan;
            this.guiCraftingPlan = new GuiCraftingPlan((GuiContainer)this, craftingPlan, this.field_147003_i, this.field_147009_r, 9, 18, 10);
            if (previousGuiCraftingPlan != null) {
                this.guiCraftingPlan.inheritVisualizationState(previousGuiCraftingPlan);
            }
            this.field_146292_n.add(new GuiButtonText(0, this.field_147003_i + 70, this.field_147009_r + 198, 100, 20, TextFormatting.BOLD + L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.cancel", (Object[])new Object[0]), true));
        } else {
            this.guiCraftingPlan = null;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            if (keyCode == 1) {
                this.returnToOverview();
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    protected ContainerTerminalCraftingJobsPlan getContainer() {
        return (ContainerTerminalCraftingJobsPlan)super.getContainer();
    }

    private void returnToOverview() {
        PartPos center = this.getContainer().getTarget().getCenter();
        OpenCraftingJobsGuiPacket.send(center.getPos().getBlockPos(), center.getSide());
    }

    public boolean requiresAction(int buttonId) {
        return true;
    }

    public void onButtonClick(int buttonId) {
        super.onButtonClick(buttonId);
        GuiButton button = (GuiButton)this.field_146292_n.get(buttonId);
        if (button instanceof GuiButtonText) {
            this.cancelCraftingJob();
        }
    }

    private void cancelCraftingJob() {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new CancelCraftingJobPacket(this.getContainer().getCraftingJobGuiData()));
        this.returnToOverview();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        } else {
            this.func_73732_a(this.field_146289_q, L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.empty", (Object[])new Object[0]), this.field_147003_i + this.getBaseXSize() / 2, this.field_147009_r + 23, 0xFFFFFF);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerForegroundLayer(mouseX, mouseY);
        }
    }

    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawCurrentScreen(mouseX, mouseY, partialTicks);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawCurrentScreen(mouseX, mouseY, partialTicks);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.handleMouseInput();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        super.onUpdate(valueId, value);
        if (this.getContainer().getCraftingPlanNotifierId() == valueId) {
            this.func_73866_w_();
        }
    }
}

