/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.GuiScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobs;
import org.cyclops.integratedterminals.network.packet.CancelCraftingJobPacket;
import org.cyclops.integratedterminals.network.packet.OpenCraftingJobsPlanGuiPacket;

public class GuiTerminalCraftingJobs
extends GuiContainerExtended {
    public static int OUTPUT_SLOT_X = 8;
    public static int OUTPUT_SLOT_Y = 17;
    public static int LINE_WIDTH = 221;
    private final EntityPlayer player;
    private GuiScrollBar scrollBar;
    private int firstRow;

    public GuiTerminalCraftingJobs(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType) {
        super((ExtendedInventoryContainer)new ContainerTerminalCraftingJobs(player, target, partContainer, partType));
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.scrollBar = new GuiScrollBar(this.field_147003_i + 236, this.field_147009_r + 18, 178, this::setFirstRow, 10);
        this.scrollBar.setTotalRows(this.getContainer().getCraftingJobs().size() - 1);
        this.field_146292_n.add(new GuiButtonText(0, this.field_147003_i + 70, this.field_147009_r + 198, 120, 20, TextFormatting.BOLD + L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.cancel_all", (Object[])new Object[0]), true));
    }

    protected ResourceLocation constructResourceLocation() {
        return new ResourceLocation("integratedterminals", this.getGuiTexture());
    }

    public String getGuiTexture() {
        return (String)IntegratedTerminals._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "crafting_plan.png";
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.drawCraftingPlans(this.field_147003_i, this.field_147009_r, partialTicks, mouseX - this.field_147003_i, mouseY - this.field_147009_r, GuiTerminalStorage.DrawLayer.BACKGROUND);
        this.func_73731_b(Minecraft.func_71410_x().field_71466_p, L10NHelpers.localize((String)"parttype.parttypes.integratedterminals.terminal_crafting_job.name", (Object[])new Object[0]), this.field_147003_i + 8, this.field_147009_r + 5, 0xFFFFFF);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawCraftingPlans(0, 0, 0.0f, mouseX, mouseY, GuiTerminalStorage.DrawLayer.FOREGROUND);
    }

    protected List<HandlerWrappedTerminalCraftingPlan> getVisiblePlans() {
        return this.getContainer().getCraftingJobs().subList(this.firstRow, Math.min(this.getContainer().getCraftingJobs().size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    protected void drawCraftingPlans(int x, int y, float partialTicks, int mouseX, int mouseY, GuiTerminalStorage.DrawLayer layer) {
        int offsetY = OUTPUT_SLOT_Y;
        for (HandlerWrappedTerminalCraftingPlan craftingPlan : this.getVisiblePlans()) {
            this.drawCraftingPlan(craftingPlan, x + OUTPUT_SLOT_X, y + offsetY, layer, partialTicks, mouseX, mouseY);
            offsetY += GuiHelpers.SLOT_SIZE;
        }
    }

    protected void drawCraftingPlan(HandlerWrappedTerminalCraftingPlan craftingPlan, int x, int y, GuiTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int xOriginal = x;
        ITerminalCraftingPlan plan = craftingPlan.getCraftingPlan();
        if (layer == GuiTerminalStorage.DrawLayer.BACKGROUND && RenderHelpers.isPointInRegion((int)(x - this.field_147003_i), (int)(y - this.field_147009_r), (int)LINE_WIDTH, (int)GuiHelpers.SLOT_SIZE, (int)mouseX, (int)mouseY)) {
            GuiTerminalCraftingJobs.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + LINE_WIDTH + 1), (int)(y + GuiHelpers.SLOT_SIZE), (int)-2130706433);
        }
        x += 4;
        for (IPrototypedIngredient<?, ?> output : plan.getOutputs()) {
            IngredientComponent ingredientComponent = output.getComponent();
            long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
            ((IIngredientComponentTerminalStorageHandler)ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY)).drawInstance(output.getPrototype(), quantity, GuiHelpers.quantityToScaledString((long)quantity), (GuiContainer)this, layer, partialTick, x, y + 1, mouseX, mouseY, null);
            x += GuiHelpers.SLOT_SIZE_INNER;
        }
        if (layer == GuiTerminalStorage.DrawLayer.BACKGROUND) {
            long tickDuration;
            String statusString = L10NHelpers.localize((String)"gui.integratedterminals.craftingplan.status", (Object[])new Object[]{L10NHelpers.localize((String)("gui.integratedterminals.craftingplan.status." + plan.getStatus().name().toLowerCase(Locale.ENGLISH) + ".name"), (Object[])new Object[0])});
            RenderHelpers.drawScaledString((FontRenderer)this.field_146289_q, (String)statusString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 1), (float)0.5f, (int)0xFFFFFF, (boolean)true);
            int dependencies = GuiTerminalCraftingJobs.getDependencies(plan);
            String dependenciesString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.dependencies", (Object[])new Object[]{dependencies});
            RenderHelpers.drawScaledString((FontRenderer)this.field_146289_q, (String)dependenciesString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 7), (float)0.5f, (int)0xFFFFFF, (boolean)true);
            if (plan.getChannel() != -1) {
                String channelString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", (Object[])new Object[]{plan.getChannel()});
                RenderHelpers.drawScaledString((FontRenderer)this.field_146289_q, (String)channelString, (int)(xOriginal + LINE_WIDTH - 40), (int)(y + 7), (float)0.5f, (int)0xFFFFFF, (boolean)true);
            }
            if ((tickDuration = plan.getTickDuration()) >= 0L) {
                String durationString = GuiCraftingPlan.getDurationString(tickDuration);
                RenderHelpers.drawScaledString((FontRenderer)this.field_146289_q, (String)durationString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 13), (float)0.5f, (int)0xFFFFFF, (boolean)true);
            }
        }
    }

    protected static int getDependencies(ITerminalCraftingPlan<?> plan) {
        int count = 1;
        for (ITerminalCraftingPlan<?> dependency : plan.getDependencies()) {
            count += GuiTerminalCraftingJobs.getDependencies(dependency);
        }
        return count;
    }

    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawCurrentScreen(mouseX, mouseY, partialTicks);
        this.scrollBar.drawCurrentScreen(mouseX, mouseY, partialTicks);
    }

    public ContainerTerminalCraftingJobs getContainer() {
        return (ContainerTerminalCraftingJobs)super.getContainer();
    }

    public boolean requiresAction(int buttonId) {
        return true;
    }

    public void onButtonClick(int buttonId) {
        super.onButtonClick(buttonId);
        GuiButton button = (GuiButton)this.field_146292_n.get(buttonId);
        if (button instanceof GuiButtonText) {
            this.cancelCraftingJobs();
        }
    }

    private void cancelCraftingJobs() {
        for (HandlerWrappedTerminalCraftingPlan craftingJob : this.getContainer().getCraftingJobs()) {
            PartPos center = this.getContainer().getTarget().getCenter();
            CraftingJobGuiData data = new CraftingJobGuiData(center.getPos().getBlockPos(), center.getSide(), this.getContainer().getChannel(), craftingJob.getHandler(), craftingJob.getCraftingPlan().getId());
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new CancelCraftingJobPacket(data));
        }
        this.player.func_71053_j();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollBar.handleMouseInput();
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingPlan getHoveredPlan(int mouseX, int mouseY) {
        if ((mouseX -= this.field_147003_i) > OUTPUT_SLOT_X && mouseX < OUTPUT_SLOT_X + LINE_WIDTH && (mouseY -= this.field_147009_r) > OUTPUT_SLOT_Y && mouseY < OUTPUT_SLOT_Y + GuiHelpers.SLOT_SIZE * this.scrollBar.getVisibleRows()) {
            int index = (mouseY - OUTPUT_SLOT_Y) / GuiHelpers.SLOT_SIZE;
            List<HandlerWrappedTerminalCraftingPlan> plans = this.getVisiblePlans();
            if (index >= 0 && index < plans.size()) {
                return plans.get(index);
            }
        }
        return null;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        HandlerWrappedTerminalCraftingPlan plan = this.getHoveredPlan(mouseX, mouseY);
        if (plan != null) {
            PartPos pos = this.getContainer().getTarget().getCenter();
            OpenCraftingJobsPlanGuiPacket.send(pos.getPos().getBlockPos(), pos.getSide(), this.getContainer().getChannel(), plan);
        }
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        super.onUpdate(valueId, value);
        if (valueId == this.getContainer().getValueIdCraftingJobs()) {
            this.func_73866_w_();
        }
    }
}

