/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackIdSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackNameSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.FluidStackQuantitySorter;
import org.cyclops.integratedterminals.client.gui.container.GuiTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public class IngredientComponentTerminalStorageHandlerFluidStack
implements IIngredientComponentTerminalStorageHandler<FluidStack, Integer> {
    private final IngredientComponent<FluidStack, Integer> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerFluidStack(IngredientComponent<FluidStack, Integer> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IngredientComponent<FluidStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack(Items.field_151131_as);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInstance(FluidStack instance, long maxQuantity, @Nullable String label, GuiContainer gui, GuiTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @Nullable List<String> additionalTooltipLines) {
        if (instance != null) {
            if (layer == GuiTerminalStorage.DrawLayer.BACKGROUND) {
                GuiHelpers.renderFluidSlot((Gui)gui, (FluidStack)instance, (int)x, (int)y);
                RenderItemExtendedSlotCount.drawSlotText((FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(label != null ? label : GuiHelpers.quantityToScaledString((long)instance.amount)), (int)x, (int)y);
                GlStateManager.func_179140_f();
            } else {
                GuiHelpers.renderTooltip((GuiContainer)gui, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(instance.getFluid().getRarity().field_77937_e + instance.getLocalizedName());
                    this.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    @Override
    public String formatQuantity(FluidStack instance) {
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.fluid.amount", (Object[])new Object[]{String.format("%,d", FluidHelpers.getAmount((FluidStack)instance))});
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    @Override
    public FluidStack getInstance(ItemStack itemStack) {
        IFluidTankProperties[] props;
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null && (props = fluidHandler.getTankProperties()).length > 0) {
            return props[0].getContents();
        }
        return null;
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        IFluidTankProperties[] props;
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null && (props = fluidHandler.getTankProperties()).length > 0) {
            return props[0].getCapacity();
        }
        return 0L;
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageFluidInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageFluidIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<FluidStack, Integer> storage, FluidStack maxInstance, EntityPlayer player) {
        return 0;
    }

    @Override
    public FluidStack insertIntoContainer(IIngredientComponentStorage<FluidStack, Integer> storage, Container container, int containerSlot, FluidStack maxInstance, @Nullable EntityPlayer player, boolean transferFullSelection) {
        ItemStack stack = container.func_75139_a(containerSlot).func_75211_c();
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null) {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), fluidHandler);
            FluidStack moved = null;
            try {
                moved = (FluidStack)IngredientStorageHelpers.moveIngredientsIterative(storage, itemStorage, (Object)maxInstance, (Object)this.ingredientComponent.getMatcher().getExactMatchNoQuantityCondition(), (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.func_75139_a(containerSlot).func_75215_d(fluidHandler.getContainer());
            container.func_75142_b();
            return moved;
        }
        return null;
    }

    protected IIngredientComponentStorage<FluidStack, Integer> getFluidStorage(IngredientComponent<FluidStack, Integer> component, IFluidHandlerItem fluidHandler) {
        return component.getStorageWrapperHandler(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).wrapComponentStorage((Object)fluidHandler);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<FluidStack, Integer> storage, InventoryPlayer playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = playerInventory.func_70445_o();
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)playerStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null) {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), fluidHandler);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            playerInventory.func_70437_b(fluidHandler.getContainer());
        }
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<FluidStack, Integer> storage, Container container, int containerSlot, InventoryPlayer playerInventory) {
        ItemStack toMoveStack = container.func_75139_a(containerSlot).func_75211_c();
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null) {
            IIngredientComponentStorage<FluidStack, Integer> itemStorage = this.getFluidStorage((IngredientComponent<FluidStack, Integer>)storage.getComponent(), fluidHandler);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, storage, (long)Long.MAX_VALUE, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.func_75139_a(containerSlot).func_75215_d(fluidHandler.getContainer());
            container.func_75142_b();
        }
    }

    @Override
    public long getActivePlayerStackQuantity(InventoryPlayer playerInventory) {
        IFluidTankProperties[] props;
        ItemStack toMoveStack = playerInventory.func_70445_o();
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null && (props = fluidHandler.getTankProperties()).length > 0) {
            return FluidHelpers.getAmount((FluidStack)props[0].getContents());
        }
        return 0L;
    }

    @Override
    public void drainActivePlayerStackQuantity(InventoryPlayer playerInventory, long quantity) {
        ItemStack toMoveStack = playerInventory.func_70445_o();
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)toMoveStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null) {
            int drained;
            while (quantity > 0L && (drained = FluidHelpers.getAmount((FluidStack)fluidHandler.drain((int)quantity, true))) > 0) {
                quantity -= (long)drained;
            }
            playerInventory.func_70437_b(fluidHandler.getContainer());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Predicate<FluidStack> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        switch (searchMode) {
            case MOD: {
                return i -> Optional.ofNullable(FluidRegistry.getModId((FluidStack)i)).orElse("minecraft").toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            }
            case TOOLTIP: {
                return i -> false;
            }
            case DICT: {
                return i -> false;
            }
            case DEFAULT: {
                return i -> i != null && i.getLocalizedName().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            }
        }
        return null;
    }

    @Override
    public Collection<IIngredientInstanceSorter<FluidStack>> getInstanceSorters() {
        return Lists.newArrayList((Object[])new IIngredientInstanceSorter[]{new FluidStackNameSorter(), new FluidStackIdSorter(), new FluidStackQuantitySorter()});
    }
}

