/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome;

import logictechcorp.libraryex.api.world.biome.BiomeBlockType;
import logictechcorp.libraryex.api.world.biome.data.IBiomeData;
import logictechcorp.libraryex.api.world.generation.GenerationStage;
import logictechcorp.libraryex.api.world.generation.trait.IBiomeTrait;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitCluster;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitFluid;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitOre;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitPool;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitScatter;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.entity.monster.EntityEmber;
import logictechcorp.netherex.entity.neutral.EntitySalamander;
import logictechcorp.netherex.init.NetherExBiomes;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.world.biome.BiomeNetherEx;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.biome.Biome;

public class BiomeTorridWasteland
extends BiomeNetherEx {
    private static final IBlockState FIERY_NETHERRACK = NetherExBlocks.FIERY_NETHERRACK.func_176223_P();

    public BiomeTorridWasteland() {
        super(NetherEx.instance, new Biome.BiomeProperties("Torrid Wasteland").func_185410_a(4.0f).func_185395_b(0.0f).func_185396_a(), "torrid_wasteland");
        this.field_76752_A = FIERY_NETHERRACK;
        this.field_76753_B = FIERY_NETHERRACK;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityMagmaCube.class, 30, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEmber.class, 25, 1, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySalamander.class, 100, 1, 2));
    }

    @Override
    public IBiomeData getBiomeData() {
        BiomeData biomeData = new BiomeData((Biome)NetherExBiomes.TORRID_WASTELAND, 6, true, false, true);
        biomeData.addBiomeBlock(BiomeBlockType.SURFACE_BLOCK, FIERY_NETHERRACK);
        biomeData.addBiomeBlock(BiomeBlockType.SUBSURFACE_BLOCK, FIERY_NETHERRACK);
        biomeData.addBiomeBlock(BiomeBlockType.CAVE_CEILING_BLOCK, FIERY_NETHERRACK);
        biomeData.addBiomeBlock(BiomeBlockType.CAVE_WALL_BLOCK, FIERY_NETHERRACK);
        biomeData.addBiomeBlock(BiomeBlockType.CAVE_FLOOR_BLOCK, FIERY_NETHERRACK);
        biomeData.addBiomeBlock(BiomeBlockType.FLUID_BLOCK, LAVA);
        biomeData.addBiomeTrait(GenerationStage.TERRAIN_ALTERATION, (IBiomeTrait)BiomeTraitPool.create(trait -> {
            trait.generationAttempts(8);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(Blocks.field_150356_k.func_176223_P());
            trait.blockToSurround(FIERY_NETHERRACK);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitFluid.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToSpawn(Blocks.field_150356_k.func_176223_P());
            trait.blockToTarget(FIERY_NETHERRACK);
            trait.generateFalling(false);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitScatter.create(trait -> {
            trait.generationAttempts(20);
            trait.randomizeGenerationAttempts(true);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToSpawn(Blocks.field_150480_ab.func_176223_P());
            trait.blockToTarget(FIERY_NETHERRACK);
            trait.placement(BiomeTraitScatter.Placement.ON_GROUND);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.randomizeGenerationAttempts(true);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToAttachTo(FIERY_NETHERRACK);
            trait.direction(EnumFacing.DOWN);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.minimumGenerationHeight(1);
            trait.maximumGenerationHeight(128);
            trait.blockToAttachTo(FIERY_NETHERRACK);
            trait.direction(EnumFacing.DOWN);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitFluid.create(trait -> {
            trait.generationAttempts(32);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(118);
            trait.blockToSpawn(Blocks.field_150356_k.func_176223_P());
            trait.blockToTarget(FIERY_NETHERRACK);
            trait.generateFalling(true);
        }));
        biomeData.addBiomeTrait(GenerationStage.ORE, (IBiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(NetherExBlocks.QUARTZ_ORE.func_176223_P());
            trait.blockToReplace(FIERY_NETHERRACK);
            trait.veinSize(14);
        }));
        biomeData.addBiomeTrait(GenerationStage.ORE, (IBiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(NetherExBlocks.BASALT.func_176223_P());
            trait.blockToReplace(FIERY_NETHERRACK);
            trait.veinSize(24);
        }));
        biomeData.addBiomeTrait(GenerationStage.ORE, (IBiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(8);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(Blocks.field_189877_df.func_176223_P());
            trait.blockToReplace(FIERY_NETHERRACK);
            trait.veinSize(32);
        }));
        return biomeData;
    }
}

