/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import logictechcorp.netherex.village.PigtificateTradeConfigManager;
import logictechcorp.netherex.village.PigtificateVillageData;
import logictechcorp.netherex.village.PigtificateVillageManager;
import logictechcorp.netherex.world.biome.NetherBiomeDataConfigManager;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="netherex")
public class WorldHandler {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
                NetherBiomeDataConfigManager.readBiomeDataConfigs();
                PigtificateTradeConfigManager.readTradeConfigs();
            }
            PigtificateVillageManager.loadVillageData(world);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        PigtificateVillageData data;
        World world = event.world;
        if (event.phase == TickEvent.Phase.START && !world.field_72995_K && (data = PigtificateVillageManager.getVillageData(world, false)) != null) {
            data.tick();
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
                NetherBiomeDataConfigManager.writeBiomeDataConfigs();
                PigtificateTradeConfigManager.writeTradeConfigs();
            }
            PigtificateVillageManager.unloadVillageData(world);
        }
    }
}

