/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import java.util.Comparator;
import java.util.List;
import logictechcorp.netherex.client.gui.GuiBreakingChanges;
import logictechcorp.netherex.handler.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListWorldSelection;
import net.minecraft.client.gui.GuiListWorldSelectionEntry;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="netherex", value={Side.CLIENT})
public class GuiScreenHandler {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private static GuiButton resetNetherButton;

    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent event) {
        GuiScreen gui = event.getGui();
        if (ConfigHandler.internalConfig.doNotChange.warnBreakingChanges && gui instanceof GuiMainMenu) {
            event.setGui((GuiScreen)new GuiBreakingChanges((GuiMainMenu)gui));
            ConfigHandler.internalConfig.doNotChange.warnBreakingChanges = false;
            MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.OnConfigChangedEvent("netherex", "NetherEx", false, false));
        }
    }

    @SubscribeEvent
    public static void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen guiScreen = event.getGui();
        List guiButtons = event.getButtonList();
        if (guiScreen instanceof GuiWorldSelection) {
            resetNetherButton = new GuiButton(GuiScreenHandler.getButtonId(guiButtons), guiScreen.field_146294_l / 2 - 154, 6, 90, 20, I18n.func_135052_a((String)"gui.netherex:select_world.reset_nether", (Object[])new Object[0]));
            GuiScreenHandler.resetNetherButton.field_146124_l = false;
            guiButtons.add(resetNetherButton);
        }
    }

    @SubscribeEvent
    public static void onMousePressed(GuiScreenEvent.MouseInputEvent.Post event) {
        GuiListWorldSelection guiWorldList;
        GuiScreen guiScreen = event.getGui();
        if (guiScreen instanceof GuiWorldSelection && (guiWorldList = (GuiListWorldSelection)ReflectionHelper.getPrivateValue(GuiWorldSelection.class, (Object)((GuiWorldSelection)guiScreen), (String[])new String[]{"field_184866_u", "selectionList"})).func_186794_f() != null) {
            GuiScreenHandler.resetNetherButton.field_146124_l = true;
        }
    }

    @SubscribeEvent
    public static void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Post event) {
        GuiListWorldSelection guiWorldList;
        GuiListWorldSelectionEntry guiWorld;
        GuiScreen guiScreen = event.getGui();
        GuiButton guiButton = event.getButton();
        if (guiScreen instanceof GuiWorldSelection && guiButton == resetNetherButton && (guiWorld = (guiWorldList = (GuiListWorldSelection)ReflectionHelper.getPrivateValue(GuiWorldSelection.class, (Object)((GuiWorldSelection)guiScreen), (String[])new String[]{"field_184866_u", "selectionList"})).func_186794_f()) != null) {
            WorldSummary worldSummary = (WorldSummary)ReflectionHelper.getPrivateValue(GuiListWorldSelectionEntry.class, (Object)guiWorld, (String[])new String[]{"field_186786_g", "worldSummary"});
            String worldDisplayName = worldSummary.func_75788_b();
            MINECRAFT.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
                if (result) {
                    MINECRAFT.func_147108_a((GuiScreen)new GuiScreenWorking());
                    ISaveFormat saveFormat = MINECRAFT.func_71359_d();
                    saveFormat.func_75800_d();
                    saveFormat.func_75802_e(worldSummary.func_75786_a() + "/DIM-1");
                    guiWorldList.func_186795_e();
                }
                MINECRAFT.func_147108_a((GuiScreen)guiWorldList.func_186796_g());
            }, I18n.func_135052_a((String)"gui.netherex:select_world.reset_nether_question", (Object[])new Object[]{worldDisplayName}), I18n.func_135052_a((String)"gui.netherex:select_world.reset_nether_warning", (Object[])new Object[]{worldDisplayName, worldDisplayName}), I18n.func_135052_a((String)"gui.netherex:select_world.reset", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), 0));
        }
    }

    private static int getButtonId(List<GuiButton> buttons) {
        int buttonId = 0;
        buttons.sort(Comparator.comparingInt(button -> button.field_146127_k));
        for (GuiButton button2 : buttons) {
            if (buttonId != button2.field_146127_k) continue;
            ++buttonId;
        }
        return buttonId;
    }
}

