/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import logictechcorp.netherex.NetherEx;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config.LangKey(value="config.netherex:title")
@Config(modid="netherex", name="netherex/netherex", category="global")
public class ConfigHandler {
    @Config.Name(value="internal")
    @Config.LangKey(value="config.netherex:internal")
    public static InternalConfig internalConfig = new InternalConfig();
    @Config.Name(value="client")
    @Config.LangKey(value="config.netherex:client")
    public static ClientConfig clientConfig = new ClientConfig();
    @Config.Name(value="compatibility")
    @Config.LangKey(value="config.netherex:compatibility")
    public static CompatibilityConfig compatibilityConfig = new CompatibilityConfig();
    @Config.Name(value="dimension")
    @Config.LangKey(value="config.netherex:dimension")
    public static DimensionConfig dimensionConfig = new DimensionConfig();
    @Config.Name(value="block")
    @Config.LangKey(value="config.netherex:block")
    public static BlockConfig blockConfig = new BlockConfig();
    @Config.Name(value="mob_effect")
    @Config.LangKey(value="config.netherex:mobEffect")
    public static MobEffectConfig mobEffectConfig = new MobEffectConfig();
    @Config.Name(value="entity")
    @Config.LangKey(value="config.netherex:entity")
    public static EntityConfig entityConfig = new EntityConfig();
    @Config.Name(value="biome")
    @Config.LangKey(value="config.netherex:biome")
    public static BiomeConfig biomeConfig = new BiomeConfig();

    @Mod.EventBusSubscriber(modid="netherex")
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("netherex")) {
                ConfigManager.sync((String)"netherex", (Config.Type)Config.Type.INSTANCE);
                NetherEx.LOGGER.info("Configuration has been saved.");
            }
        }
    }

    public static class BiomeConfig {
        @Config.Name(value="arctic_abyss")
        @Config.LangKey(value="config.netherex:biome.arcticAbyss")
        public ArcticAbyss arcticAbyss = new ArcticAbyss();

        public class ArcticAbyss {
            @Config.LangKey(value="config.netherex:biome.arcticAbyss.canPlayersFreeze")
            @Config.Comment(value={"Whether or not players can freeze in the Arctic Abyss"})
            public boolean canPlayersFreeze = false;
            @Config.LangKey(value="config.netherex:biome.arcticAbyss.mobFreezeRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for mobs to freeze in the Arctic Abyss biome", "The lower the number, the more common it is for mobs to freeze in the Arctic Abyss biome"})
            @Config.RangeInt(min=1)
            public int mobFreezeRarity = 512;
        }
    }

    public static class EntityConfig {
        @Config.Name(value="ember")
        @Config.LangKey(value="config.netherex:entity.ember")
        public Ember ember = new Ember();
        @Config.Name(value="nethermite")
        @Config.LangKey(value="config.netherex:entity.nethermite")
        public Nethermite nethermite = new Nethermite();
        @Config.Name(value="spinout")
        @Config.LangKey(value="config.netherex:entity.spinout")
        public Spinout spinout = new Spinout();
        @Config.Name(value="spore_creeper")
        @Config.LangKey(value="config.netherex:entity.sporeCreeper")
        public SporeCreeper sporeCreeper = new SporeCreeper();
        @Config.Name(value="spore")
        @Config.LangKey(value="config.netherex:entity.spore")
        public Spore spore = new Spore();
        @Config.Name(value="brute")
        @Config.LangKey(value="config.netherex:entity.brute")
        public Brute brute = new Brute();
        @Config.Name(value="ghast_queen")
        @Config.LangKey(value="config.netherex:entity.ghastQueen")
        public GhastQueen ghastQueen = new GhastQueen();

        public class GhastQueen {
            @Config.LangKey(value="config.netherex:entity.ghastQueen.ghastlingSpawnCooldown")
            @Config.Comment(value={"The lower the number, the less cooldown the Ghast Queen has after spawning Ghastlings", "The higher the number, the more cooldown the Ghast Queen has after spawning Ghastlings"})
            @Config.RangeInt(min=1)
            public int ghastlingSpawnCooldown = 10;
            @Config.LangKey(value="config.netherex:entity.ghastQueen.ghastlingSpawnAmount")
            @Config.Comment(value={"The lower the number, the less Ghastling spawn", "The higher the number, the more Ghastling spawn"})
            @Config.RangeInt(min=1)
            public int ghastlingSpawnAmount = 4;
        }

        public class Brute {
            @Config.LangKey(value="config.netherex:entity.brute.chargeCooldown")
            @Config.Comment(value={"The lower the number, the less cooldown the Brute has after charging", "The higher the number, the more cooldown the Brute has after charging"})
            @Config.RangeInt(min=1)
            public int chargeCooldown = 2;
        }

        public class Spore {
            @Config.LangKey(value="config.netherex:entity.spore.growthTime")
            @Config.Comment(value={"The lower the number, the less it takes a Spore to grow", "The higher the number, the more time it takes for a Spore to grow"})
            @Config.RangeInt(min=1)
            public int growthTime = 60;
            @Config.LangKey(value="config.netherex:entity.spore.creeperSpawnAmount")
            @Config.Comment(value={"The lower the number, the less Spore Creepers spawn from a Spore", "The higher the number, the more Spore Creepers spawn from a Spore"})
            @Config.RangeInt(min=1)
            public int creeperSpawnAmount = 3;
        }

        public class SporeCreeper {
            @Config.LangKey(value="config.netherex:entity.sporeCreeper.sporeSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for a Spore Creeper to spawn a Spore on death", "The lower the number, the more common it is for a Spore Creeper to spawn a Spore on death"})
            @Config.RangeInt(min=1)
            public int sporeSpawnRarity = 12;
        }

        public class Spinout {
            @Config.LangKey(value="config.netherex:entity.spinout.spinTime")
            @Config.Comment(value={"The lower the number, the less time a Spinout spins", "The higher the number, the more time a Spinout spins"})
            @Config.RangeInt(min=1)
            public int spinTime = 6;
            @Config.LangKey(value="config.netherex:entity.spinout.spinCooldown")
            @Config.Comment(value={"The lower the number, the less time a Spinout goes without spinning", "The higher the number, the more time a Spinout goes without spinning"})
            @Config.RangeInt(min=1)
            public int spinCooldown = 2;
        }

        public class Nethermite {
            @Config.LangKey(value="config.netherex:entity.nethermite.spawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for a Nethermite to spawn", "The lower the number, the more common it is for a Nethermite to spawn", "If set to 0, Nethermites won't spawn"})
            @Config.RangeInt(min=0)
            public int spawnRarity = 64;
            @Config.LangKey(value="config.netherex:entity.nethermite.blockWhitelist")
            @Config.Comment(value={"Blocks the Nethermite will spawn from"})
            public String[] blockWhitelist = new String[]{"minecraft:quartz_ore", "netherex:ore_quartz", "netherex:ore_amethyst", "netherex:ore_rime", "tconstruct:ore", "nethermetals:nether_coal_ore", "nethermetals:nether_redstone_ore", "nethermetals:nether_diamond_ore", "nethermetals:nether_emerald_ore", "nethermetals:nether_gold_ore", "nethermetals:nether_iron_ore", "nethermetals:nether_lapis_ore", "nethermetals:nether_antimony_ore", "nethermetals:nether_bismuth_ore", "nethermetals:nether_copper_ore", "nethermetals:nether_lead_ore", "nethermetals:nether_mercury_ore", "nethermetals:nether_nickel_ore", "nethermetals:nether_platnium_ore", "nethermetals:nether_silver_ore", "nethermetals:nether_tin_ore", "nethermetals:nether_zinc_ore", "nethermetals:nether_aluminum_ore", "nethermetals:nether_cadmium_ore", "nethermetals:nether_chromium_ore", "nethermetals:nether_iridium_ore", "nethermetals:nether_magnesium_ore", "nethermetals:nether_magnanese_ore", "nethermetals:nether_osmium_ore", "nethermetals:nether_plutonium_ore", "nethermetals:nether_rutile_ore", "nethermetals:nether_tantalum_ore", "nethermetals:nether_titanium_ore", "nethermetals:nether_tungsten_ore", "nethermetals:nether_uramium_ore", "nethermetals:nether_zirconium_ore"};
        }

        public class Ember {
            @Config.LangKey(value="config.netherex:entity.ember.setPlayerOnFireRarity")
            @Config.Comment(value={"The higher the number, the rarer it is to set a player on fire", "The lower the number, the more common it is to set a player on fire", "If set to 0, Embers won't set Players on fire"})
            @Config.RangeInt(min=0)
            public int setPlayerOnFireRarity = 2;
        }
    }

    public static class MobEffectConfig {
        @Config.Name(value="freeze")
        @Config.LangKey(value="config.netherex:mobEffect.freeze")
        public Freeze freeze = new Freeze();
        @Config.Name(value="spore")
        @Config.LangKey(value="config.netherex:mobEffect.spore")
        public Spore spore = new Spore();
        @Config.Name(value="lost")
        @Config.LangKey(value="config.netherex:mobEffect.lost")
        public Lost lost = new Lost();

        public class Lost {
            @Config.LangKey(value="config.netherex:mobEffect.lost.ghastlingSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is to spawn a Ghastling", "The lower the number, the more common it is to spawn a Ghastling"})
            @Config.RangeInt(min=1)
            public int ghastlingSpawnRarity = 256;
        }

        public class Spore {
            @Config.LangKey(value="config.netherex:mobEffect.spore.sporeSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is to spawn a Spore", "The lower the number, the more common it is to spawn a Spore"})
            @Config.RangeInt(min=1)
            public int sporeSpawnRarity = 128;
            @Config.LangKey(value="config.netherex:mobEffect.spore.mobBlacklist")
            @Config.Comment(value={"Mobs that shouldn't spawn Spores"})
            public String[] mobBlacklist = new String[]{"netherex:spore_creeper", "netherex:spore", "netherex:mogus"};
        }

        public class Freeze {
            @Config.LangKey(value="config.netherex:mobEffect.freeze.thawRarity")
            @Config.Comment(value={"The higher the number, the rarer it is to thaw", "The lower the number, the more common it is to thaw"})
            @Config.RangeInt(min=1)
            public int thawRarity = 1024;
            @Config.LangKey(value="config.netherex:mobEffect.freeze.mobBlacklist")
            @Config.Comment(value={"Mobs that won't freeze"})
            public String[] mobBlacklist = new String[]{"minecraft:blaze", "minecraft:ghast", "minecraft:wither_skeleton", "minecraft:polar_bear", "netherex:wight", "netherex:ember", "netherex:spinout", "netherex:coolmar_spider", "netherex:brute"};
        }
    }

    public static class BlockConfig {
        @Config.Name(value="blue_fire")
        @Config.LangKey(value="config.netherex:block.blueFire")
        public BlueFire blueFire = new BlueFire();
        @Config.Name(value="nether_portal")
        @Config.LangKey(value="config.netherex:block.netherPortal")
        public NetherPortal netherPortal = new NetherPortal();
        @Config.Name(value="magma")
        @Config.LangKey(value="config.netherex:block.magma")
        public Magma magma = new Magma();
        @Config.Name(value="rime")
        @Config.LangKey(value="config.netherex:block.rime")
        public Rime rime = new Rime();
        @Config.Name(value="thornstalk")
        @Config.LangKey(value="config.netherex:block.thornstalk")
        public Thornstalk thornstalk = new Thornstalk();
        @Config.Name(value="hyphae")
        @Config.LangKey(value="config.netherex:block.hyphae")
        public Hyphae hyphae = new Hyphae();

        public class Hyphae {
            @Config.LangKey(value="config.netherex:block.hyphae.shouldSpread")
            public boolean shouldSpread = false;
        }

        public class Thornstalk {
            @Config.LangKey(value="config.netherex:block.thornstalk.canDestroyItems")
            public boolean canDestroyItems = false;
            @Config.LangKey(value="config.netherex:block.thornstalk.mobBlacklist")
            @Config.Comment(value={"Mobs Thornstalk won't hurt"})
            public String[] mobBlacklist = new String[]{"minecraft:wither_skeleton", "minecraft:zombie_pigman", "netherex:spinout"};
        }

        public class Rime {
            @Config.LangKey(value="config.netherex:block.rime.canFreezeWater")
            public boolean canFreezeWater = true;
            @Config.LangKey(value="config.netherex:block.rime.canFreezeLava")
            public boolean canFreezeLava = true;
            @Config.LangKey(value="config.netherex:block.rime.canFreezeMobs")
            public boolean canFreezeMobs = true;
        }

        public class Magma {
            @Config.LangKey(value="config.netherex:block.magma.turnIntoLavaWhenBroken")
            public boolean turnIntoLavaWhenBroken = false;
        }

        public class NetherPortal {
            @Config.RangeInt(min=0)
            @Config.LangKey(value="config.netherex:block.netherPortal.pigmanSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for Pigman to spawn", "The lower the number, the more common it is for Pigman to spawn", "If set to 0, Pigman won't spawn"})
            public int pigmanSpawnRarity = 2000;
        }

        public class BlueFire {
            @Config.LangKey(value="config.netherex:block.blueFire.minEntityTicksAlight")
            @Config.Comment(value={"The minimum amount of ticks Blue Fire can set entities alight", "A number is randomly chosen from minEntityTicksAlight to maxEntityTicksAlight"})
            @Config.RangeInt(min=0)
            public int minEntityTicksAlight = 0;
            @Config.LangKey(value="config.netherex:block.blueFire.maxEntityTicksAlight")
            @Config.Comment(value={"The maximum amount of ticks Blue Fire can set entities alight", "A number is randomly chosen from minEntityTicksAlight to maxEntityTicksAlight"})
            @Config.RangeInt(min=1)
            public int maxEntityTicksAlight = 70;
        }
    }

    public static class DimensionConfig {
        @Config.Name(value="nether")
        @Config.LangKey(value="config.netherex:dimension.nether")
        public Nether nether = new Nether();

        public class Nether {
            @Config.RequiresMcRestart
            @Config.LangKey(value="config.netherex:dimension.nether.overrideNether")
            public boolean overrideNether = true;
            @Config.LangKey(value="config.netherex:dimension.nether.generateSoulSand")
            public boolean generateSoulSand = false;
            @Config.LangKey(value="config.netherex:dimension.nether.generateGravel")
            public boolean generateGravel = false;
            @Config.LangKey(value="config.netherex:dimension.nether.isLavaInfinite")
            public boolean isLavaInfinite = false;
        }
    }

    public static class CompatibilityConfig {
        @Config.Name(value="biomesoplenty")
        @Config.LangKey(value="config.netherex:compatibility.biomesOPlenty")
        public BiomesOPlenty biomesOPlenty = new BiomesOPlenty();

        public class BiomesOPlenty {
            @Config.LangKey(value="config.netherex:compatibility.biomesOPlenty.enableCompatibility")
            public boolean enableCompatibility = true;
        }
    }

    public static class ClientConfig {
        @Config.Name(value="visual")
        @Config.LangKey(value="config.netherex:client.visual")
        public Visual visual = new Visual();

        public class Visual {
            @Config.LangKey(value="config.netherex:client.visual.disableNetherFog")
            public boolean disableNetherFog = true;
        }
    }

    public static class InternalConfig {
        @Config.Name(value="do_not_change")
        @Config.LangKey(value="config.netherex:internal.doNotChange")
        public DoNotChange doNotChange = new DoNotChange();

        public class DoNotChange {
            @Config.LangKey(value="config.netherex:internal.doNotChange.warnBreakingChanges")
            public boolean warnBreakingChanges = true;
            @Config.RangeInt(min=1, max=1)
            @Config.LangKey(value="config.netherex:internal.doNotChange.configVersion")
            public int configVersion = 1;
        }
    }
}

