/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import logictechcorp.libraryex.item.ItemModHammer;
import logictechcorp.libraryex.utility.CollectionHelper;
import logictechcorp.netherex.entity.monster.EntityNethermite;
import logictechcorp.netherex.handler.ConfigHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="netherex")
public class BlockHandler {
    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        EntityPlayer player = event.getPlayer();
        NBTTagCompound compound = player.func_184586_b(event.getHand()).func_77978_p();
        if (state.func_177230_c() == Blocks.field_150357_h && compound != null && compound.func_74767_n("AboveNether") && (player.field_71093_bK != DimensionType.NETHER.func_186068_a() || pos.func_177956_o() < 120)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        if (!(event.getPlayer() instanceof FakePlayer)) {
            EntityPlayer player = event.getPlayer();
            if (state.func_177230_c() == Blocks.field_189877_df && ConfigHandler.blockConfig.magma.turnIntoLavaWhenBroken && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) == 0) {
                world.func_180501_a(pos, Blocks.field_150353_l.func_176223_P(), 3);
                player.func_184614_ca().func_77972_a(1, (EntityLivingBase)player);
                event.setCanceled(true);
            }
            if (player.field_71093_bK == DimensionType.NETHER.func_186068_a()) {
                boolean canSpawnNethermites = CollectionHelper.contains((String[])ConfigHandler.entityConfig.nethermite.blockWhitelist, (String)state.func_177230_c().getRegistryName().toString());
                if (ConfigHandler.entityConfig.nethermite.spawnRarity > 0 && canSpawnNethermites && world.field_73012_v.nextInt(ConfigHandler.entityConfig.nethermite.spawnRarity) == 0) {
                    EntityNethermite nethermite = new EntityNethermite(world);
                    nethermite.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    world.func_72838_d((Entity)nethermite);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        IBlockState state = event.getState();
        EntityPlayer player = event.getHarvester();
        if (player != null && state.func_177230_c() == Blocks.field_150357_h && player.func_184614_ca().func_77973_b() instanceof ItemModHammer) {
            ItemStack stack = new ItemStack(Blocks.field_150357_h, 1, 0);
            stack.func_77983_a("AboveNether", (NBTBase)new NBTTagByte(1));
            event.getDrops().add(stack);
        }
    }

    @SubscribeEvent
    public static void onCreateFluidSource(BlockEvent.CreateFluidSourceEvent event) {
        World world = event.getWorld();
        IBlockState state = event.getState();
        if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a() && (state.func_177230_c() == Blocks.field_150353_l || state.func_177230_c() == Blocks.field_150356_k)) {
            event.setResult(ConfigHandler.dimensionConfig.nether.isLavaInfinite ? Event.Result.ALLOW : Event.Result.DEFAULT);
        }
    }
}

