/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.entity.monster;

import logictechcorp.netherex.handler.ConfigHandler;
import logictechcorp.netherex.init.NetherExLootTables;
import logictechcorp.netherex.init.NetherExSoundEvents;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySpinout
extends EntityMob {
    private int spinCounter;
    private int spinCooldown;
    private boolean spinning;
    private final EntityAIBase attackMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
    private final EntityAIBase wander = new EntityAIWander((EntityCreature)this, 1.0, 1);

    public EntitySpinout(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.55f, 1.95f);
    }

    protected SoundEvent func_184639_G() {
        return NetherExSoundEvents.SPINOUT_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.SPINOUT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.SPINOUT_DEATH;
    }

    public void func_184185_a(SoundEvent sound, float volume, float pitch) {
        if (!this.func_174814_R() || this.func_174814_R() && sound != NetherExSoundEvents.SPINOUT_AMBIENT) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, this.func_184176_by(), volume, pitch);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.spinCooldown == 0) {
            ++this.spinCounter;
            if (!this.spinning) {
                this.spinning = true;
            }
            if (this.field_70714_bg.field_75782_a.size() == 1) {
                this.field_70714_bg.func_75776_a(1, this.attackMelee);
                this.field_70714_bg.func_75776_a(2, this.wander);
            }
            if (this.func_174814_R()) {
                this.func_174810_b(false);
            }
        }
        if (this.spinCounter >= ConfigHandler.entityConfig.spinout.spinTime * 20) {
            this.spinCounter = 0;
            this.spinning = false;
            this.spinCooldown = ConfigHandler.entityConfig.spinout.spinCooldown * 20;
        }
        if (this.spinCooldown > 0) {
            --this.spinCooldown;
            if (this.field_70714_bg.field_75782_a.size() == 3) {
                this.field_70714_bg.func_85156_a(this.attackMelee);
                this.field_70714_bg.func_85156_a(this.wander);
            }
            if (!this.func_174814_R()) {
                this.func_174810_b(true);
            }
            this.func_70661_as().func_75499_g();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SpinCounter", this.spinCounter);
        compound.func_74768_a("SpinCooldown", this.spinCooldown);
        compound.func_74757_a("Spinning", this.spinning);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spinCounter = compound.func_74762_e("SpinCounter");
        this.spinCooldown = compound.func_74762_e("SpinCooldown");
        this.spinning = compound.func_74767_n("Spinning");
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return (!source.func_76352_a() || !this.isSpinning()) && super.func_70097_a(source, amount);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return NetherExLootTables.SPINOUT;
    }

    public boolean isSpinning() {
        return this.spinning;
    }
}

