/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.block;

import java.util.List;
import java.util.Random;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.init.NetherExItems;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnokiMushroomStem
extends BlockMod {
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public BlockEnokiMushroomStem() {
        super(NetherEx.getResource("enoki_mushroom_stem"), new BlockProperties(Material.field_151585_k, MapColor.field_151666_j).sound(SoundType.field_185848_a).hardness(0.4f));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        Block block = blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        return block != this && side != EnumFacing.UP;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!this.canSurviveAt(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block blockDown = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block blockUp = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        Block blockNorth = world.func_180495_p(pos.func_177978_c()).func_177230_c();
        Block blockEast = world.func_180495_p(pos.func_177974_f()).func_177230_c();
        Block blockSouth = world.func_180495_p(pos.func_177968_d()).func_177230_c();
        Block blockWest = world.func_180495_p(pos.func_177976_e()).func_177230_c();
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(blockDown == this || blockDown == NetherExBlocks.ENOKI_MUSHROOM_CAP)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(blockUp == this || blockUp == NetherExBlocks.LIVELY_NETHERRACK || blockUp == NetherExBlocks.ENOKI_MUSHROOM_CAP)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(blockNorth == this || blockNorth == NetherExBlocks.ENOKI_MUSHROOM_CAP)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(blockEast == this || blockEast == NetherExBlocks.ENOKI_MUSHROOM_CAP)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(blockSouth == this || blockSouth == NetherExBlocks.ENOKI_MUSHROOM_CAP)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(blockWest == this || blockWest == NetherExBlocks.ENOKI_MUSHROOM_CAP));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float minX = (Boolean)(state = state.func_185899_b(source, pos)).func_177229_b((IProperty)WEST) != false ? 0.0f : 0.1875f;
        float minY = (Boolean)state.func_177229_b((IProperty)DOWN) != false ? 0.0f : 0.1875f;
        float minZ = (Boolean)state.func_177229_b((IProperty)NORTH) != false ? 0.0f : 0.1875f;
        float maxX = (Boolean)state.func_177229_b((IProperty)EAST) != false ? 1.0f : 0.8125f;
        float maxY = (Boolean)state.func_177229_b((IProperty)UP) != false ? 1.0f : 0.8125f;
        float maxZ = (Boolean)state.func_177229_b((IProperty)SOUTH) != false ? 1.0f : 0.8125f;
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean bool) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125));
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.1875, 0.8125, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.8125, 0.1875, 0.1875, 1.0, 0.8125, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.8125, 0.1875, 0.8125, 1.0, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.1875));
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockEnokiMushroomStem.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.8125, 0.8125, 0.8125, 1.0));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canSurviveAt(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canSurviveAt(world, pos)) {
            world.func_175684_a(pos, (Block)this, 1);
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        if (random.nextInt(4) == 0) {
            return NetherExItems.ENOKI_MUSHROOM;
        }
        return Items.field_190931_a;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    private boolean canSurviveAt(World world, BlockPos pos) {
        boolean airOnTop = world.func_175623_d(pos.func_177984_a());
        boolean airOnBottom = world.func_175623_d(pos.func_177977_b());
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            Block block = world.func_180495_p(offsetPos).func_177230_c();
            if (block != this) continue;
            if (!airOnTop && !airOnBottom) {
                return false;
            }
            IBlockState stateUp = world.func_180495_p(offsetPos.func_177984_a());
            if (stateUp.func_177230_c() != this && stateUp.func_177230_c() != Blocks.field_150424_aL && stateUp != NetherExBlocks.LIVELY_NETHERRACK) continue;
            return true;
        }
        IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
        return stateUp.func_177230_c() == this || stateUp.func_177230_c() == Blocks.field_150424_aL || stateUp == NetherExBlocks.LIVELY_NETHERRACK;
    }
}

