/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileAutoCraftingTable
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="autocrafter", key="AutoCrafterInput", comment="AutoCrafting Table Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="autocrafter", key="AutoCrafterMaxEnergy", comment="AutoCrafting Table Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public int[] craftingSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private int outputSlot = 9;
    public Inventory inventory = new Inventory(11, "TileAutoCraftingTable", 64, (TileEntity)this);
    public IRecipe currentRecipe;
    public ItemStack currentRecipeOutput;
    public int tickTime;
    public int maxProgress = 120;
    public int euTick = 10;
    public int balanceSlot = 0;
    InventoryCrafting inventoryCrafting = null;
    public boolean locked = true;

    public InventoryCrafting getCraftingInventory() {
        if (this.inventoryCrafting == null) {
            this.inventoryCrafting = new InventoryCrafting(new Container(){

                public boolean func_75145_c(EntityPlayer playerIn) {
                    return false;
                }
            }, 3, 3);
        }
        for (int i = 0; i < 9; ++i) {
            this.inventoryCrafting.func_70299_a(i, this.inventory.func_70301_a(i));
        }
        return this.inventoryCrafting;
    }

    public boolean canMake(InventoryCrafting craftMatrix) {
        ItemStack stack = this.findMatchingRecipeOutput(craftMatrix);
        if (this.locked) {
            for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                ItemStack stack1 = craftMatrix.func_70301_a(i);
                if (stack1.func_190926_b() || stack1.func_190916_E() >= 2) continue;
                return false;
            }
        }
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack output = this.func_70301_a(this.outputSlot);
        if (output.func_190926_b()) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)output, (boolean)true, (boolean)true);
    }

    boolean hasRoomForExtraItem(ItemStack stack) {
        ItemStack extraOutputSlot = this.func_70301_a(10);
        if (extraOutputSlot.func_190926_b()) {
            return true;
        }
        return this.hasOutputSpace(stack, 10);
    }

    public boolean hasOutputSpace(ItemStack output, int slot) {
        ItemStack stack = this.inventory.func_70301_a(slot);
        if (stack.func_190926_b()) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)output, (boolean)true, (boolean)true) && stack.func_77976_d() > stack.func_190916_E() + output.func_190916_E();
    }

    private void handleContainerItem(ItemStack stack) {
        if (stack.func_77973_b().hasContainerItem(stack)) {
            ItemStack containerItem = stack.func_77973_b().getContainerItem(stack);
            ItemStack extraOutputSlot = this.func_70301_a(10);
            if (this.hasOutputSpace(containerItem, 10)) {
                if (extraOutputSlot.func_190926_b()) {
                    this.func_70299_a(10, containerItem.func_77946_l());
                } else if (ItemUtils.isItemEqual((ItemStack)extraOutputSlot, (ItemStack)containerItem, (boolean)true, (boolean)true) && extraOutputSlot.func_77976_d() < extraOutputSlot.func_190916_E() + containerItem.func_190916_E()) {
                    extraOutputSlot.func_190917_f(1);
                }
            }
        }
    }

    public boolean hasIngredient(Ingredient ingredient) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (!ingredient.apply(stack)) continue;
            return true;
        }
        return false;
    }

    public Optional<InventoryCrafting> balanceRecipe(InventoryCrafting craftCache) {
        ItemStack sourceStack;
        if (this.currentRecipe == null) {
            return Optional.empty();
        }
        if (this.field_145850_b.field_72995_K) {
            return Optional.empty();
        }
        if (!this.locked) {
            return Optional.empty();
        }
        if (craftCache.func_191420_l()) {
            return Optional.empty();
        }
        ++this.balanceSlot;
        if (this.balanceSlot > craftCache.func_70302_i_()) {
            this.balanceSlot = 0;
        }
        if ((sourceStack = this.inventory.func_70301_a(this.balanceSlot)).func_190926_b()) {
            return Optional.empty();
        }
        ArrayList<Integer> possibleSlots = new ArrayList<Integer>();
        for (int s = 0; s < this.currentRecipe.func_192400_c().size(); ++s) {
            ItemStack stackInSlot = this.inventory.func_70301_a(s);
            Ingredient ingredient = (Ingredient)this.currentRecipe.func_192400_c().get(s);
            if (ingredient == Ingredient.field_193370_a || !ingredient.apply(sourceStack)) continue;
            if (stackInSlot.func_190926_b()) {
                possibleSlots.add(s);
                continue;
            }
            if (stackInSlot.func_77973_b() != sourceStack.func_77973_b() || stackInSlot.func_77952_i() != sourceStack.func_77952_i()) continue;
            possibleSlots.add(s);
        }
        if (!possibleSlots.isEmpty()) {
            int totalItems = possibleSlots.stream().mapToInt(value -> this.inventory.func_70301_a(value.intValue()).func_190916_E()).sum();
            int slots = possibleSlots.size();
            int[] split = new int[slots];
            int remainder = totalItems % slots;
            Arrays.fill(split, totalItems / slots);
            while (remainder > 0) {
                for (int i = 0; i < split.length; ++i) {
                    if (remainder <= 0) continue;
                    int n = i;
                    split[n] = split[n] + 1;
                    --remainder;
                }
            }
            List slotDistrubution = possibleSlots.stream().mapToInt(value -> this.inventory.func_70301_a(value.intValue()).func_190916_E()).boxed().collect(Collectors.toList());
            boolean needsBalance = false;
            for (int i = 0; i < split.length; ++i) {
                int required = split[i];
                if (slotDistrubution.contains(required)) {
                    slotDistrubution.remove(new Integer(required));
                    continue;
                }
                needsBalance = true;
            }
            if (!needsBalance) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        Pair bestSlot = null;
        for (Integer slot : possibleSlots) {
            ItemStack slotStack = this.inventory.func_70301_a(slot.intValue());
            if (slotStack.func_190926_b()) {
                bestSlot = Pair.of((Object)slot, (Object)0);
            }
            if (bestSlot == null) {
                bestSlot = Pair.of((Object)slot, (Object)slotStack.func_190916_E());
                continue;
            }
            if ((Integer)bestSlot.getRight() < slotStack.func_190916_E()) continue;
            bestSlot = Pair.of((Object)slot, (Object)slotStack.func_190916_E());
        }
        if (bestSlot == null || (Integer)bestSlot.getLeft() == this.balanceSlot || ((Integer)bestSlot.getRight()).intValue() == sourceStack.func_190916_E() || this.inventory.func_70301_a(((Integer)bestSlot.getLeft()).intValue()).func_190926_b() || !ItemUtils.isItemEqual((ItemStack)sourceStack, (ItemStack)this.inventory.func_70301_a(((Integer)bestSlot.getLeft()).intValue()), (boolean)true, (boolean)true, (boolean)true)) {
            return Optional.empty();
        }
        sourceStack.func_190918_g(1);
        this.inventory.func_70301_a(((Integer)bestSlot.getLeft()).intValue()).func_190917_f(1);
        this.inventory.hasChanged = true;
        return Optional.of(this.getCraftingInventory());
    }

    public int getProgress() {
        return this.tickTime;
    }

    public void setProgress(int progress) {
        this.tickTime = progress;
    }

    public int getMaxProgress() {
        if (this.maxProgress == 0) {
            this.maxProgress = 1;
        }
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public IRecipe findMatchingRecipe(InventoryCrafting crafting) {
        if (crafting.func_191420_l()) {
            return null;
        }
        if (this.currentRecipe != null && this.currentRecipe.func_77569_a(crafting, this.field_145850_b)) {
            return this.currentRecipe;
        }
        return CraftingManager.func_192413_b((InventoryCrafting)crafting, (World)this.field_145850_b);
    }

    public ItemStack findMatchingRecipeOutput(InventoryCrafting crafting) {
        return this.findMatchingRecipe(crafting).func_77571_b().func_77946_l();
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge(10);
        InventoryCrafting craftMatrix = this.getCraftingInventory();
        if (this.inventory.hasChanged) {
            this.currentRecipe = this.findMatchingRecipe(craftMatrix);
        }
        if (this.currentRecipe != null && !this.currentRecipe.func_77569_a(craftMatrix, this.field_145850_b)) {
            this.currentRecipe = null;
            this.inventory.hasChanged = true;
        }
        if (this.currentRecipe != null) {
            Optional<InventoryCrafting> balanceResult;
            if (this.field_145850_b.func_82737_E() % 2L == 0L && (balanceResult = this.balanceRecipe(craftMatrix)).isPresent()) {
                craftMatrix = balanceResult.get();
            }
            this.currentRecipeOutput = this.currentRecipe.func_77572_b(craftMatrix);
        } else {
            this.currentRecipeOutput = ItemStack.field_190927_a;
        }
        if (!this.currentRecipeOutput.func_190926_b() && this.canMake(craftMatrix)) {
            if (this.tickTime >= Math.max((int)((double)this.maxProgress * (1.0 - this.getSpeedMultiplier())), 1)) {
                this.currentRecipeOutput = this.findMatchingRecipeOutput(craftMatrix);
                if (!this.currentRecipeOutput.func_190926_b()) {
                    boolean hasCrafted = false;
                    if (this.inventory.func_70301_a(this.outputSlot).func_190926_b()) {
                        this.inventory.func_70299_a(this.outputSlot, this.currentRecipeOutput);
                        this.tickTime = 0;
                        hasCrafted = true;
                    } else if (this.inventory.func_70301_a(this.outputSlot).func_190916_E() + this.currentRecipeOutput.func_190916_E() <= this.currentRecipeOutput.func_77976_d()) {
                        ItemStack stack = this.inventory.func_70301_a(this.outputSlot);
                        stack.func_190920_e(stack.func_190916_E() + this.currentRecipeOutput.func_190916_E());
                        this.inventory.func_70299_a(this.outputSlot, stack);
                        this.tickTime = 0;
                        hasCrafted = true;
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                            this.inventory.func_70298_a(i, 1);
                        }
                        this.currentRecipeOutput = ItemStack.field_190927_a;
                        this.currentRecipe = null;
                    }
                }
            }
        } else {
            this.tickTime = 0;
        }
        if (!this.currentRecipeOutput.func_190926_b() && this.canUseEnergy(this.getEuPerTick(this.euTick)) && this.tickTime < Math.max((int)((double)this.maxProgress * (1.0 - this.getSpeedMultiplier())), 1) && this.canMake(craftMatrix)) {
            this.useEnergy(this.getEuPerTick(this.euTick));
            ++this.tickTime;
        }
        if (this.currentRecipeOutput.func_190926_b()) {
            this.tickTime = 0;
            this.currentRecipe = null;
        }
    }

    public int getLockedInt() {
        return this.locked ? 1 : 0;
    }

    public void setLockedInt(int lockedInt) {
        this.locked = lockedInt == 1;
        this.inventory.hasChanged = true;
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public boolean canAcceptEnergy(EnumFacing enumFacing) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing enumFacing) {
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74757_a("locked", this.locked);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("locked")) {
            this.locked = tag.func_74767_n("locked");
        }
        this.inventory.hasChanged = true;
        super.func_145839_a(tag);
    }

    public boolean canBeUpgraded() {
        return true;
    }

    public EnumFacing getFacingEnum() {
        return EnumFacing.NORTH;
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.AUTO_CRAFTING_TABLE, 1);
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("autocraftingtable").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 28, 25).slot(1, 46, 25).slot(2, 64, 25).slot(3, 28, 43).slot(4, 46, 43).slot(5, 64, 43).slot(6, 28, 61).slot(7, 46, 61).slot(8, 64, 61).outputSlot(9, 145, 42).onCraft(inv -> this.inventory.func_70299_a(1, this.findMatchingRecipeOutput(this.getCraftingInventory()))).outputSlot(10, 145, 70).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).syncIntegerValue(this::getMaxProgress, this::setMaxProgress).syncIntegerValue(this::getLockedInt, this::setLockedInt).addInventory().create((RebornMachineTile)this);
    }

    public boolean hasSlotConfig() {
        return true;
    }
}

