/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ItemUtils;
import techreborn.utils.OreDictUtils;
import techreborn.utils.TechRebornCreativeTab;

public class ItemJackhammer
extends ItemPickaxe
implements IEnergyItemInfo {
    public int maxCharge = 1;
    public int cost = 250;
    public double transferLimit = 100.0;

    public ItemJackhammer(Item.ToolMaterial material, String unlocalizedName, int energyCapacity) {
        super(material);
        this.field_77864_a = 20.0f;
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77625_d(1);
        this.func_77656_e(240);
        this.func_77655_b(unlocalizedName);
        this.maxCharge = energyCapacity;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if ((OreDictUtils.isOre(state, "stone") || state.func_177230_c() == Blocks.field_150348_b) && new ForgePowerItemManager(stack).getEnergyStored() >= this.cost) {
            return this.field_77864_a;
        }
        return 0.5f;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        Random rand = new Random();
        if (rand.nextInt(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack) + 1) == 0) {
            ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
            capEnergy.extractEnergy(this.cost, false);
            ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityLiving);
        }
        return true;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return OreDictUtils.isOre(state, "stone") || state.func_185904_a() == Material.field_151576_e && new ForgePowerItemManager(stack).getEnergyStored() >= this.cost;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.func_77969_a(oldStack);
    }

    public double getMaxPower(ItemStack stack) {
        return this.maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return this.transferLimit;
    }
}

