/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.BaseBlock;
import reborncore.common.blocks.PropertyString;
import reborncore.common.util.ArrayUtils;
import techreborn.blocks.BlockStorage2;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModBlocks;
import techreborn.utils.TechRebornCreativeTab;

public class BlockStorage
extends BaseBlock {
    public static final String[] types = new String[]{"silver", "aluminum", "titanium", "chrome", "steel", "brass", "lead", "electrum", "zinc", "platinum", "tungsten", "nickel", "invar", "iridium", "bronze"};
    public static final PropertyString TYPE = new PropertyString("type", types);
    private static final List<String> typesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])types));

    public BlockStorage() {
        super(Material.field_151573_f);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)"silver")));
        for (int i = 0; i < types.length; ++i) {
            ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, i, new IProperty[0]).setInvVariant("type=" + types[i]).setFileName("storage"));
        }
        TRRecipeHandler.hideEntry(this);
    }

    public static ItemStack getStorageBlockByName(String name, int count) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(name)) continue;
            return new ItemStack(ModBlocks.STORAGE, count, i);
        }
        return BlockStorage2.getStorageBlockByName(name, count);
    }

    public static ItemStack getStorageBlockByName(String name) {
        return BlockStorage.getStorageBlockByName(name, 1);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > types.length) {
            meta = 0;
        }
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)typesList.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return typesList.indexOf(state.func_177229_b((IProperty)TYPE));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }
}

