/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorBramble
extends GeneratorReplacing {
    protected int minLength;
    protected int maxLength;
    protected int maxHeight;
    protected int generationAttempts;

    public GeneratorBramble(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int minLength, int maxLength, int maxHeight, int generationAttempts) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.maxHeight = maxHeight;
        this.generationAttempts = generationAttempts;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        for (int i = 0; i < this.generationAttempts; ++i) {
            BlockPos genPos = pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(3) - rand.nextInt(3), rand.nextInt(4) - rand.nextInt(4));
            if (!this.placeOn.matches(world, genPos.func_177977_b()) || !this.replace.matches(world, genPos)) continue;
            int targetLength = GeneratorUtils.nextIntBetween(rand, this.minLength, this.maxLength);
            int height = 0;
            int direction = rand.nextInt(4) + 2;
            block5: for (int length = 0; length <= targetLength && this.replace.matches(world, genPos); ++length) {
                if (this.with.func_177230_c().func_176196_c(world, genPos)) {
                    world.func_175656_a(genPos, this.with);
                    if (rand.nextInt(2) == 0) {
                        direction = rand.nextInt(4) + 2;
                    }
                    if (rand.nextInt(2) == 0) {
                        int leafDirection = rand.nextInt(6);
                        if (world.func_175623_d(genPos.func_177972_a(EnumFacing.values()[leafDirection]))) {
                            world.func_175656_a(genPos.func_177972_a(EnumFacing.values()[leafDirection]), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
                        }
                    }
                    switch (rand.nextInt(6)) {
                        case 0: 
                        case 1: {
                            if (height > this.maxHeight) continue block5;
                            genPos = genPos.func_177984_a();
                            ++height;
                            break;
                        }
                        case 2: {
                            if (height < 0) continue block5;
                            genPos = genPos.func_177977_b();
                            --height;
                            break;
                        }
                        default: {
                            genPos = genPos.func_177972_a(EnumFacing.values()[direction]);
                            break;
                        }
                    }
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.with = conf.getBlockState("with", this.with);
        this.minLength = conf.getInt("minLength", this.minLength);
        this.maxLength = conf.getInt("maxLength", this.maxLength);
        this.maxHeight = conf.getInt("maxHeight", this.maxHeight);
        this.generationAttempts = conf.getInt("generationAttempts", this.generationAttempts);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorBramble>
    implements IGenerator.IGeneratorBuilder<GeneratorBramble> {
        protected int minLength;
        protected int maxLength;
        protected int maxHeight;
        protected int generationAttempts;

        public Builder minLength(int a) {
            this.minLength = a;
            return (Builder)this.self();
        }

        public Builder maxLength(int a) {
            this.maxLength = a;
            return (Builder)this.self();
        }

        public Builder maxHeight(int a) {
            this.maxHeight = a;
            return (Builder)this.self();
        }

        public Builder generationAttempts(int a) {
            this.generationAttempts = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = new BlockQuery.BlockQueryMaterial(Material.field_151578_c, Material.field_151577_b);
            this.replace = BlockQueries.airOrLeaves;
            this.with = BOPBlocks.bramble_plant.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
            this.minLength = 15;
            this.maxLength = 30;
            this.maxHeight = 6;
            this.generationAttempts = 128;
        }

        @Override
        public GeneratorBramble create() {
            return new GeneratorBramble(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.minLength, this.maxLength, this.maxHeight, this.generationAttempts);
        }
    }
}

