/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.world;

import epicsquid.mysticalworld.world.data.DataHelper;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class StructureGenerator
implements IWorldGenerator {
    private final ResourceLocation structure;
    private final int descent;
    private final int maxDistance;
    private final Supplier<Class<? extends Entity>> entity;
    private static ResourceLocation loot = new ResourceLocation("minecraft", "chests/simple_dungeon");

    public StructureGenerator(ResourceLocation structure, int descent, Supplier<Class<? extends Entity>> entity, int maxDistance) {
        this.structure = structure;
        this.descent = descent;
        this.entity = entity;
        this.maxDistance = maxDistance * maxDistance;
    }

    private BlockPos testPlacement(int[] heightmap, BlockPos size, int x, int z, int deviation) {
        int max = 0;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < size.func_177958_n(); ++i) {
            for (int j = 0; j < size.func_177952_p(); ++j) {
                if (i != 0 && i != size.func_177958_n() - 1 && j != 0 && j != size.func_177952_p() - 1) continue;
                int index = z + j << 4 | x + i;
                int height = heightmap[index];
                if (height > max) {
                    max = height;
                }
                if (height < min) {
                    min = height;
                }
                if (max - min <= deviation) continue;
                return null;
            }
        }
        return new BlockPos(x, max, z);
    }

    private BlockPos testPlacement(int[] heightMap, BlockPos size, int chunkSize, int deviation) {
        int structureX = chunkSize - size.func_177958_n() + 1;
        int structureZ = chunkSize - size.func_177952_p() + 1;
        for (int x = 0; x < structureX; ++x) {
            for (int z = 0; z < structureZ; ++z) {
                BlockPos pos = this.testPlacement(heightMap, size, x, z, deviation);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    private boolean testForLiquids(World world, BlockPos start, BlockPos size) {
        BlockPos stop = start.func_177982_a(size.func_177958_n(), 0, size.func_177956_o());
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)start, (BlockPos)stop)) {
            BlockPos pos2 = world.func_175672_r(pos);
            IBlockState state = world.func_180495_p(pos2);
            if (!(state.func_177230_c() instanceof BlockLiquid)) continue;
            return false;
        }
        return true;
    }

    public ResourceLocation getRegistryName() {
        return this.structure;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos size;
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (!world.func_72912_H().func_76089_r()) {
            return;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (random.nextInt(5) == 0) {
            return;
        }
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        BlockPos zxPos = new BlockPos(cx, 0, cz);
        Biome biome = world.func_180494_b(zxPos);
        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            return;
        }
        ChunkProviderServer serverProvider = ((WorldServer)world).func_72863_F();
        if (serverProvider.func_193413_a(world, "Village", zxPos)) {
            return;
        }
        if (serverProvider.func_193413_a(world, "Mansion", zxPos)) {
            return;
        }
        MinecraftServer minecraftserver = world.func_73046_m();
        TemplateManager templatemanager = world.func_72860_G().func_186340_h();
        Template template = templatemanager.func_186237_a(minecraftserver, this.structure);
        Chunk chunk = world.func_175726_f(zxPos);
        int[] heightMap = chunk.func_177445_q();
        BlockPos pos = this.testPlacement(heightMap, size = template.func_186259_a(), 16, 0);
        if (pos == null) {
            return;
        }
        if (!DataHelper.testBlockPos(this.structure, pos = pos.func_177982_a(zxPos.func_177958_n(), 0, zxPos.func_177952_p()), this.maxDistance, world)) {
            return;
        }
        if (!this.testForLiquids(world, pos, size)) {
            return;
        }
        PlacementSettings placementsettings = new PlacementSettings();
        ChunkPos chunkpos = new ChunkPos(pos);
        StructureBoundingBox structureboundingbox = new StructureBoundingBox(chunkpos.func_180334_c(), 0, chunkpos.func_180333_d(), chunkpos.func_180332_e(), 256, chunkpos.func_180330_f());
        placementsettings.func_186223_a(structureboundingbox);
        Rotation rotation = random.nextBoolean() ? Rotation.NONE : Rotation.CLOCKWISE_180;
        placementsettings.func_186220_a(rotation);
        placementsettings.func_189946_a(1.0f);
        placementsettings.func_186222_a(false);
        placementsettings.func_186218_a(chunkpos);
        placementsettings.func_186226_b(false);
        placementsettings.func_189950_a(random);
        pos = Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)pos).func_177979_c(this.descent);
        if (pos.func_177956_o() <= 0) {
            return;
        }
        template.func_189962_a(world, pos, placementsettings, 16);
        IBlockState chest = Blocks.field_150486_ae.func_176223_P();
        IBlockState cobble = Blocks.field_150347_e.func_176223_P();
        Map data = template.func_186258_a(pos, placementsettings);
        DataHelper.putBlockPos(this.structure, pos, world);
        data.forEach((blockPos, s) -> {
            if (s.equals("spawner")) {
                if (world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 16)) {
                    TileEntityMobSpawner ms;
                    TileEntity te = world.func_175625_s(blockPos);
                    int i = 0;
                    while (!(te instanceof TileEntityMobSpawner)) {
                        if (++i == 10) {
                            throw new IllegalStateException("[Mystical World] Failed to replace structure block with mob spawner at " + blockPos.func_177958_n() + "/" + blockPos.func_177956_o() + "/" + blockPos.func_177952_p() + " after 10 attempts. This should not happen.");
                        }
                        world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 16);
                        te = world.func_175625_s(blockPos);
                    }
                    if (te instanceof TileEntityMobSpawner && (ms = (TileEntityMobSpawner)te) != null) {
                        ResourceLocation key = EntityList.func_191306_a(this.entity.get());
                        if (key == null) {
                            key = EntityList.func_191306_a(EntityZombie.class);
                        }
                        ms.func_145881_a().func_190894_a(key);
                    }
                }
            } else if (s.equals("loot_chest1") || s.equals("loot_chest2") || s.equals("loot_chest3")) {
                if (!s.equals("loot_chest3") && random.nextBoolean()) {
                    world.func_180501_a(blockPos, cobble, 16);
                } else if (world.func_180501_a(blockPos, chest, 16)) {
                    TileEntity te = world.func_175625_s(blockPos);
                    int i = 0;
                    while (!(te instanceof TileEntityChest)) {
                        if (++i == 10) {
                            throw new IllegalStateException("[Mystical World] Failed to replace structure block with a chest at " + blockPos.func_177958_n() + "/" + blockPos.func_177956_o() + "/" + blockPos.func_177952_p() + " after 10 attempts. This should not happen.");
                        }
                        world.func_180501_a(blockPos, chest, 16);
                        te = world.func_175625_s(blockPos);
                    }
                    if (te instanceof TileEntityChest) {
                        ((TileEntityChest)te).func_189404_a(loot, world.func_72905_C() * (long)blockPos.func_177958_n() + (long)blockPos.func_177956_o() ^ (long)blockPos.func_177952_p());
                    }
                }
            }
        });
    }
}

