/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.proxy;

import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.mysticalworld.integration.jer.JERIntegration;
import epicsquid.mysticalworld.loot.conditions.HasHorns;
import epicsquid.mysticalworld.world.OreGenerator;
import epicsquid.mysticalworld.world.StructureGenerator;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    private static ResourceLocation BARROW = new ResourceLocation("mysticalworld", "barrow");
    private static ResourceLocation HUT = new ResourceLocation("mysticalworld", "hut");
    private StructureGenerator hutGenerator;
    private StructureGenerator barrowGenerator;

    public void preInit(FMLPreInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)1);
    }

    public void init(FMLInitializationEvent event) {
        ModItems.registerOredict();
        if (Loader.isModLoaded((String)"jeresources")) {
            JERIntegration.init();
        }
        LootConditionManager.func_186639_a((LootCondition.Serializer)new HasHorns.Serializer());
        if (ConfigManager.BarrowDistance != -1) {
            this.barrowGenerator = new StructureGenerator(BARROW, 10, () -> {
                switch (Util.rand.nextInt(6)) {
                    case 0: 
                    case 1: {
                        return EntitySkeleton.class;
                    }
                }
                return EntityZombie.class;
            }, ConfigManager.BarrowDistance);
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.barrowGenerator, (int)400);
        }
        if (ConfigManager.HutDistance != -1) {
            this.hutGenerator = new StructureGenerator(HUT, 6, () -> {
                if (Util.rand.nextInt(4) == 0) {
                    return EntityWitch.class;
                }
                return EntityZombie.class;
            }, ConfigManager.HutDistance);
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.hutGenerator, (int)400);
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
    }
}

