/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.gui;

import mods.railcraft.client.gui.GuiContainerRailcraft;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.widgets.Widget;
import net.minecraft.entity.player.InventoryPlayer;
import pl.asie.computronics.integration.railcraft.gui.container.ContainerTicketMachine;
import pl.asie.computronics.integration.railcraft.gui.tooltip.ToolTips;
import pl.asie.computronics.integration.railcraft.gui.widget.ButtonWidget;
import pl.asie.computronics.integration.railcraft.gui.widget.LockButtonWidget;
import pl.asie.computronics.integration.railcraft.gui.widget.PrintButtonWidget;
import pl.asie.computronics.integration.railcraft.tile.TileTicketMachine;
import pl.asie.computronics.util.StringUtil;

public class GuiTicketMachine
extends GuiContainerRailcraft {
    private final TileTicketMachine tile;
    private boolean maintenanceMode = false;
    private String ownerName = "[Unknown]";
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private ToolTip notownedToolTips;
    private ToolTip notmaintenanceToolTips;
    private static final ToolTip printToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.print", 0, new String[0]);
    private static final ToolTip printLockedToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.printLocked", 0, new String[0]);

    public GuiTicketMachine(InventoryPlayer inventory, TileTicketMachine tile, boolean maintenanceMode) {
        super((RailcraftContainer)new ContainerTicketMachine(inventory, tile, maintenanceMode), "computronics:textures/gui/ticket_machine.png");
        this.tile = tile;
        this.maintenanceMode = maintenanceMode;
        this.ownerName = tile.getOwner().getName();
        this.lockedToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.locked", 500, "{owner}=" + this.ownerName);
        this.unlockedToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.unlocked", 500, "{owner}=" + this.ownerName);
        this.notownedToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.notowner", 500, "{owner}=" + this.ownerName);
        this.notmaintenanceToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.notmaintenance", 500, "{owner}=" + this.ownerName);
    }

    public boolean maintenanceMode() {
        return this.maintenanceMode;
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b(StringUtil.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String name = StringUtil.localize(this.tile.getLocalizationTag());
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 4, 0x404040);
    }

    protected void func_146273_a(int x, int y, int mouseButton, long time) {
        super.func_146273_a(x, y, mouseButton, time);
        int mX = x - this.field_147003_i;
        int mY = y - this.field_147009_r;
        for (Widget widget : this.container.getWidgets()) {
            if (!(widget instanceof ButtonWidget)) continue;
            ((ButtonWidget)widget).handleMouseMove(mX, mY, mouseButton, time);
        }
    }

    protected void func_146286_b(int x, int y, int eventType) {
        super.func_146286_b(x, y, eventType);
        int mX = x - this.field_147003_i;
        int mY = y - this.field_147009_r;
        for (Widget widget : this.container.getWidgets()) {
            if (!(widget instanceof ButtonWidget)) continue;
            ((ButtonWidget)widget).handleMouseRelease(mX, mY, eventType);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
    }

    private void updateButtons() {
        String username = this.tile.getOwner().getName();
        if (username != null && !username.equals(this.ownerName)) {
            this.ownerName = username;
            this.lockedToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.locked", 500, "{owner}=" + this.ownerName);
            this.unlockedToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.unlocked", 500, "{owner}=" + this.ownerName);
            this.notownedToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.notowner", 500, "{owner}=" + this.ownerName);
            this.notmaintenanceToolTips = ToolTips.buildToolTip("tooltip.computronics.ticket.notmaintenance", 500, "{owner}=" + this.ownerName);
        }
        for (Widget widget : this.container.getWidgets()) {
            if (widget instanceof LockButtonWidget) {
                if (((LockButtonWidget)widget).accessible) {
                    ((LockButtonWidget)widget).setToolTip(this.tile.isLocked() ? this.lockedToolTips : this.unlockedToolTips);
                    continue;
                }
                ((LockButtonWidget)widget).setToolTip(((ContainerTicketMachine)this.container).canLock ? this.notmaintenanceToolTips : this.notownedToolTips);
                continue;
            }
            if (!(widget instanceof PrintButtonWidget)) continue;
            ((PrintButtonWidget)widget).setToolTip(this.tile.isPrintLocked() ? printLockedToolTips : printToolTips);
        }
    }
}

