/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.builderpattern;

import com.lothrazar.cyclicmagic.block.builderpattern.BlockPatternBuilder;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.capability.EnergyStore;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPatternBuilder
extends TileEntityBaseMachineInvo
implements ITickable,
ITilePreviewToggle,
ITileRedstoneToggle {
    private static final int MAXIMUM = 32;
    private static final String NBT_REDST = "redstone";
    private static final int TIMER_FULL = 20;
    private static final int TIMER_SKIP = 1;
    private int height = 5;
    private int offsetTargetX = -5;
    private int offsetTargetY = 0;
    private int offsetTargetZ = 1;
    private int offsetSourceX = 5;
    private int offsetSourceY = 0;
    private int offsetSourceZ = 1;
    private int sizeRadius = 4;
    private int timer = 1;
    private int needsRedstone = 1;
    private int renderParticles = 1;
    private int flipX = 0;
    private int flipY = 0;
    private int flipZ = 0;
    private int rotation = 0;
    private Map<String, String> blockToItemOverrides = new HashMap<String, String>();

    public TileEntityPatternBuilder() {
        super(18);
        this.initEnergy(new EnergyStore(64000), BlockPatternBuilder.FUEL_COST);
        this.setSlotsForBoth();
        this.syncBlockItemMap();
    }

    private void syncBlockItemMap() {
        this.blockToItemOverrides.put("minecraft:redstone_wire", "minecraft:redstone");
        this.blockToItemOverrides.put("minecraft:powered_repeater", "minecraft:repeater");
        this.blockToItemOverrides.put("minecraft:unpowered_repeater", "minecraft:repeater");
        this.blockToItemOverrides.put("minecraft:powered_comparator", "minecraft:comparator");
        this.blockToItemOverrides.put("minecraft:unpowered_comparator", "minecraft:comparator");
        this.blockToItemOverrides.put("minecraft:lit_redstone_ore", "minecraft:redstone_ore");
        this.blockToItemOverrides.put("minecraft:tripwire", "minecraft:string");
        this.blockToItemOverrides.put("minecraft:wall_sign", "minecraft:sign");
        this.blockToItemOverrides.put("minecraft:standing_sign", "minecraft:sign");
        this.blockToItemOverrides.put("minecraft:lit_furnace", "minecraft:furnace");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    private BlockPos getCenterTarget() {
        return this.func_174877_v().func_177982_a(this.offsetTargetX, this.offsetTargetY, this.offsetTargetZ);
    }

    private BlockPos getCenterSrc() {
        return this.func_174877_v().func_177982_a(this.offsetSourceX, this.offsetSourceY, this.offsetSourceZ);
    }

    private int findSlotForMatch(IBlockState stateToMatch) {
        int slot = -1;
        if (stateToMatch == null || stateToMatch.func_177230_c() == null) {
            return slot;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            String itemInSlot;
            String itemKey;
            ItemStack is = this.func_70301_a(i);
            if (UtilItemStack.isEmpty(is)) continue;
            Item itemFromState = Item.func_150898_a((Block)stateToMatch.func_177230_c());
            if (itemFromState == is.func_77973_b()) {
                slot = i;
                break;
            }
            String blockKey = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)stateToMatch.func_177230_c())).toString();
            if (!this.blockToItemOverrides.containsKey(blockKey) || !(itemKey = this.blockToItemOverrides.get(blockKey)).equalsIgnoreCase(itemInSlot = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)is.func_77973_b())).toString())) continue;
            slot = i;
            break;
        }
        return slot;
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass < 2;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 0;
            List<BlockPos> shapeSrc = this.getSourceShape();
            List<BlockPos> shapeTarget = this.getTargetShape();
            if (shapeSrc.size() <= 0) {
                return;
            }
            int pTarget = this.field_145850_b.field_73012_v.nextInt(shapeSrc.size());
            BlockPos posSrc = shapeSrc.get(pTarget);
            BlockPos posTarget = shapeTarget.get(pTarget);
            if (this.renderParticles == 1) {
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CRIT_MAGIC, posSrc);
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CRIT_MAGIC, posTarget);
            }
            if (!this.field_145850_b.func_175623_d(posSrc) && this.field_145850_b.func_175623_d(posTarget)) {
                IBlockState stateToMatch = this.field_145850_b.func_180495_p(posSrc);
                int slot = this.findSlotForMatch(stateToMatch);
                if (slot < 0) {
                    return;
                }
                this.timer = 20;
                this.field_145850_b.func_175656_a(posTarget, stateToMatch);
                this.func_70298_a(slot, 1);
                SoundType type = UtilSound.getSoundFromBlockstate(stateToMatch, this.field_145850_b, posTarget);
                if (type != null && type.func_185841_e() != null) {
                    int dim = this.getDimension();
                    int range = 18;
                    UtilSound.playSoundFromServer(type.func_185841_e(), SoundCategory.BLOCKS, posTarget, dim, range);
                }
            } else {
                this.timer = 1;
            }
        }
    }

    public BlockPos getSourceCenter() {
        return this.func_174877_v().func_177982_a(this.offsetSourceX, this.offsetSourceY, this.offsetSourceZ);
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177982_a(this.offsetTargetX, this.offsetTargetY, this.offsetTargetZ);
    }

    public List<BlockPos> getSourceFrameOutline() {
        BlockPos centerSrc = this.getSourceCenter();
        List<BlockPos> shapeSrc = UtilShape.cubeFrame(centerSrc, this.sizeRadius, this.height);
        return shapeSrc;
    }

    public List<BlockPos> getTargetFrameOutline() {
        return UtilShape.cubeFrame(this.getTargetCenter(), this.sizeRadius, this.height);
    }

    private BlockPos convertPosSrcToTarget(BlockPos posSrc) {
        BlockPos centerSrc = this.getCenterSrc();
        int xOffset = posSrc.func_177958_n() - centerSrc.func_177958_n();
        int yOffset = posSrc.func_177956_o() - centerSrc.func_177956_o();
        int zOffset = posSrc.func_177952_p() - centerSrc.func_177952_p();
        BlockPos centerTarget = this.getCenterTarget();
        return centerTarget.func_177982_a(xOffset, yOffset, zOffset);
    }

    public List<BlockPos> getSourceShape() {
        BlockPos centerSrc = this.getSourceCenter();
        return UtilShape.readAllSolid(this.field_145850_b, centerSrc, this.sizeRadius, this.height);
    }

    public Map<BlockPos, IBlockState> getShapeFancy(List<BlockPos> sourceShape, List<BlockPos> targetShape) {
        HashMap<BlockPos, IBlockState> map = new HashMap<BlockPos, IBlockState>();
        for (int i = 0; i < targetShape.size(); ++i) {
            BlockPos src = sourceShape.get(i);
            BlockPos targ = targetShape.get(i);
            if (!this.field_145850_b.func_175623_d(targ)) continue;
            map.put(targ, this.field_145850_b.func_180495_p(src));
        }
        return map;
    }

    public List<BlockPos> getTargetShape() {
        List<BlockPos> shapeSrc = this.getSourceShape();
        List<BlockPos> shapeTarget = new ArrayList<BlockPos>();
        for (BlockPos p : shapeSrc) {
            shapeTarget.add(this.convertPosSrcToTarget(new BlockPos((Vec3i)p)));
        }
        shapeTarget = UtilShape.rotateShape(this.getCenterTarget(), shapeTarget, this.getRotation());
        BlockPos trueCenter = this.getCenterTarget().func_177981_b(this.getHeight() / 2);
        if (this.getField(Fields.FLIPX) == 1) {
            shapeTarget = UtilShape.flipShape(trueCenter, shapeTarget, EnumFacing.Axis.X);
        }
        if (this.getField(Fields.FLIPY) == 1) {
            shapeTarget = UtilShape.flipShape(trueCenter, shapeTarget, EnumFacing.Axis.Y);
        }
        if (this.getField(Fields.FLIPZ) == 1) {
            shapeTarget = UtilShape.flipShape(trueCenter, shapeTarget, EnumFacing.Axis.Z);
        }
        return shapeTarget;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.offsetTargetX = compound.func_74762_e("ox");
        this.offsetTargetY = compound.func_74762_e("oy");
        this.offsetTargetZ = compound.func_74762_e("oz");
        this.offsetSourceX = compound.func_74762_e("sx");
        this.offsetSourceY = compound.func_74762_e("sy");
        this.offsetSourceZ = compound.func_74762_e("sz");
        this.sizeRadius = compound.func_74762_e("r");
        this.height = compound.func_74762_e("height");
        this.timer = compound.func_74762_e("timer");
        this.renderParticles = compound.func_74762_e("render");
        this.needsRedstone = compound.func_74762_e(NBT_REDST);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("ox", this.offsetTargetX);
        compound.func_74768_a("oy", this.offsetTargetY);
        compound.func_74768_a("oz", this.offsetTargetZ);
        compound.func_74768_a("sx", this.offsetSourceX);
        compound.func_74768_a("sy", this.offsetSourceY);
        compound.func_74768_a("sz", this.offsetSourceZ);
        compound.func_74768_a("r", this.sizeRadius);
        compound.func_74768_a("height", this.height);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("render", this.renderParticles);
        compound.func_74768_a(NBT_REDST, this.needsRedstone);
        return super.func_189515_b(compound);
    }

    public int getHeight() {
        return this.height;
    }

    public Rotation getRotation() {
        return Rotation.values()[this.rotation];
    }

    public String getRotationName() {
        switch (this.getRotation()) {
            case CLOCKWISE_90: {
                return "90";
            }
            case CLOCKWISE_180: {
                return "180";
            }
            case COUNTERCLOCKWISE_90: {
                return "270";
            }
        }
        return "None";
    }

    public int getField(Fields f) {
        switch (f) {
            case OFFTARGX: {
                return this.offsetTargetX;
            }
            case OFFTARGY: {
                return this.offsetTargetY;
            }
            case OFFTARGZ: {
                return this.offsetTargetZ;
            }
            case SIZER: {
                return this.sizeRadius;
            }
            case OFFSRCX: {
                return this.offsetSourceX;
            }
            case OFFSRCY: {
                return this.offsetSourceY;
            }
            case OFFSRCZ: {
                return this.offsetSourceZ;
            }
            case HEIGHT: {
                return this.getHeight();
            }
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
            case ROTATION: {
                return this.rotation;
            }
            case FLIPX: {
                return this.flipX;
            }
            case FLIPY: {
                return this.flipY;
            }
            case FLIPZ: {
                return this.flipZ;
            }
        }
        return 0;
    }

    public void setField(Fields f, int value) {
        if (value > 32 && f.ordinal() < Fields.ROTATION.ordinal()) {
            value = 32;
        }
        switch (f) {
            case OFFTARGX: {
                this.offsetTargetX = value;
                break;
            }
            case OFFTARGY: {
                this.offsetTargetY = value;
                break;
            }
            case OFFTARGZ: {
                this.offsetTargetZ = value;
                break;
            }
            case SIZER: {
                this.sizeRadius = value;
                break;
            }
            case OFFSRCX: {
                this.offsetSourceX = value;
                break;
            }
            case OFFSRCY: {
                this.offsetSourceY = value;
                break;
            }
            case OFFSRCZ: {
                this.offsetSourceZ = value;
                break;
            }
            case HEIGHT: {
                this.height = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % RenderType.values().length;
                break;
            }
            case ROTATION: {
                this.rotation = value % Rotation.values().length;
                break;
            }
            case FLIPX: {
                this.flipX = value % 2;
                break;
            }
            case FLIPY: {
                this.flipY = value % 2;
                break;
            }
            case FLIPZ: {
                this.flipZ = value % 2;
            }
        }
    }

    public RenderType getRenderType() {
        return RenderType.values()[this.renderParticles];
    }

    @Override
    public int func_174887_a_(int id) {
        return this.getField(Fields.values()[id]);
    }

    @Override
    public void func_174885_b(int id, int value) {
        this.setField(Fields.values()[id], value);
    }

    public void swapTargetSource() {
        int srcX = this.offsetSourceX;
        int srcY = this.offsetSourceY;
        int srcZ = this.offsetSourceZ;
        this.offsetSourceX = this.offsetTargetX;
        this.offsetSourceY = this.offsetTargetY;
        this.offsetSourceZ = this.offsetTargetZ;
        this.offsetTargetX = srcX;
        this.offsetTargetY = srcY;
        this.offsetTargetZ = srcZ;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.renderParticles == 1;
    }

    @Override
    public List<BlockPos> getShape() {
        return this.getTargetShape();
    }

    public static enum Fields {
        OFFTARGX,
        OFFTARGY,
        OFFTARGZ,
        SIZER,
        OFFSRCX,
        OFFSRCY,
        OFFSRCZ,
        HEIGHT,
        TIMER,
        REDSTONE,
        RENDERPARTICLES,
        ROTATION,
        FLIPX,
        FLIPY,
        FLIPZ;

    }

    static enum RenderType {
        OFF,
        OUTLINE,
        PHANTOM,
        SOLID;

    }
}

