/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks.fluids;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.blocks.fluids.BlockFluidRustic;
import rustic.common.blocks.fluids.FluidBooze;
import rustic.common.blocks.fluids.FluidDrinkable;
import rustic.common.potions.PotionsRustic;

public class ModFluids {
    public static Fluid OLIVE_OIL;
    public static Fluid IRONBERRY_JUICE;
    public static Fluid WILDBERRY_JUICE;
    public static Fluid GRAPE_JUICE;
    public static Fluid APPLE_JUICE;
    public static Fluid ALE_WORT;
    public static Fluid HONEY;
    public static Fluid ALE;
    public static Fluid CIDER;
    public static Fluid IRON_WINE;
    public static Fluid MEAD;
    public static Fluid WILDBERRY_WINE;
    public static Fluid WINE;
    private static List<Fluid> FLUIDS;
    public static BlockFluidRustic BLOCK_OLIVE_OIL;
    public static BlockFluidRustic BLOCK_IRONBERRY_JUICE;
    public static BlockFluidRustic BLOCK_WILDBERRY_JUICE;
    public static BlockFluidRustic BLOCK_GRAPE_JUICE;
    public static BlockFluidRustic BLOCK_APPLE_JUICE;
    public static BlockFluidRustic BLOCK_ALE_WORT;
    public static BlockFluidRustic BLOCK_HONEY;

    public static void init() {
        OLIVE_OIL = new FluidDrinkable("oliveoil", new ResourceLocation("rustic:blocks/fluids/olive_oil_still"), new ResourceLocation("rustic:blocks/fluids/olive_oil_flow")){

            @Override
            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 0.4f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 600, 1));
            }
        }.setDensity(920).setViscosity(2000);
        ModFluids.register(OLIVE_OIL);
        IRONBERRY_JUICE = new FluidDrinkable("ironberryjuice", new ResourceLocation("rustic:blocks/fluids/ironberry_juice_still"), new ResourceLocation("rustic:blocks/fluids/ironberry_juice_flow")){

            @Override
            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 0.8f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 600, 15, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 600, 15, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600, 15, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 600, 15, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 600, 15, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 600, 250, false, false));
            }
        }.setDensity(1100).setViscosity(1100);
        ModFluids.register(IRONBERRY_JUICE);
        WILDBERRY_JUICE = new FluidDrinkable("wildberryjuice", new ResourceLocation("rustic:blocks/fluids/wildberry_juice_still"), new ResourceLocation("rustic:blocks/fluids/wildberry_juice_flow")){

            @Override
            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 1.0f);
                if (player.func_70681_au().nextFloat() < 0.2f) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 75));
                }
                if (player.func_70681_au().nextFloat() < 0.1f) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200));
                }
            }
        }.setDensity(1070).setViscosity(1100);
        ModFluids.register(WILDBERRY_JUICE);
        GRAPE_JUICE = new FluidDrinkable("grapejuice", new ResourceLocation("rustic:blocks/fluids/grape_juice_still"), new ResourceLocation("rustic:blocks/fluids/grape_juice_flow")){

            @Override
            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 0.9f);
            }
        }.setDensity(1070).setViscosity(1100);
        ModFluids.register(GRAPE_JUICE);
        APPLE_JUICE = new FluidDrinkable("applejuice", new ResourceLocation("rustic:blocks/fluids/apple_juice_still"), new ResourceLocation("rustic:blocks/fluids/apple_juice_flow")){

            @Override
            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 1.2f);
            }
        }.setDensity(1050).setViscosity(1100);
        ModFluids.register(APPLE_JUICE);
        ALE_WORT = new FluidDrinkable("alewort", new ResourceLocation("rustic:blocks/fluids/ale_wort_still"), new ResourceLocation("rustic:blocks/fluids/ale_wort_flow")){

            @Override
            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(1, 2.0f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 400, 1));
            }
        }.setDensity(1004).setViscosity(2000);
        ModFluids.register(ALE_WORT);
        HONEY = new FluidDrinkable("honey", new ResourceLocation("rustic:blocks/fluids/honey_still"), new ResourceLocation("rustic:blocks/fluids/honey_flow")){

            @Override
            public void onDrank(World world, EntityPlayer player, ItemStack stack, FluidStack fluid) {
                player.func_71024_bL().func_75122_a(3, 0.4f);
                if (player.func_70681_au().nextFloat() < 0.6f) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 75));
                }
            }
        }.setDensity(1433).setViscosity(5500);
        ModFluids.register(HONEY);
        ALE = new FluidBooze("ale", new ResourceLocation("rustic:blocks/fluids/booze/ale_still"), new ResourceLocation("rustic:blocks/fluids/booze/ale_flow")){

            @Override
            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 4.0f * quality;
                    player.func_71024_bL().func_75122_a(2, saturation);
                    int duration = (int)(12000.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
                    player.func_70690_d(new PotionEffect(PotionsRustic.FULL_POTION, duration));
                } else {
                    int duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, duration));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1004).setViscosity(1016);
        ModFluids.register(ALE, false);
        CIDER = new FluidBooze("cider", new ResourceLocation("rustic:blocks/fluids/booze/cider_still"), new ResourceLocation("rustic:blocks/fluids/booze/cider_flow")){

            @Override
            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    int duration = (int)(12000.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
                    player.func_70690_d(new PotionEffect(PotionsRustic.MAGIC_RESISTANCE_POTION, duration));
                } else {
                    int duration = (int)(1200.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration));
                    duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1004).setViscosity(1400);
        ModFluids.register(CIDER, false);
        IRON_WINE = new FluidBooze("ironwine", new ResourceLocation("rustic:blocks/fluids/booze/iron_wine_still"), new ResourceLocation("rustic:blocks/fluids/booze/iron_wine_flow")){

            @Override
            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 2.0f * quality;
                    float absorption = 10.0f * Math.max((quality - 0.5f) * 2.0f, 0.0f);
                    player.func_71024_bL().func_75122_a(1, saturation);
                    player.func_110149_m(Math.max(Math.min(player.func_110139_bj() + absorption, 20.0f), player.func_110139_bj()));
                } else {
                    int duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    float damage = 10.0f * Math.max(Math.abs(quality - 0.5f) + 0.1f, 0.0f);
                    player.func_70097_a(DamageSource.field_76376_m, damage);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1034).setViscosity(1400);
        ModFluids.register(IRON_WINE, false);
        MEAD = new FluidBooze("mead", new ResourceLocation("rustic:blocks/fluids/booze/mead_still"), new ResourceLocation("rustic:blocks/fluids/booze/mead_flow")){

            @Override
            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    int duration = (int)(6000.0f * Math.max(Math.abs((quality - 0.5f) * 2.0f), 0.0f));
                    player.func_70690_d(new PotionEffect(PotionsRustic.WITHER_WARD_POTION, duration));
                } else {
                    int duration = (int)(800.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_82731_v, duration));
                    duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1034).setViscosity(1500);
        ModFluids.register(MEAD, false);
        WILDBERRY_WINE = new FluidBooze("wildberrywine", new ResourceLocation("rustic:blocks/fluids/booze/wildberry_wine_still"), new ResourceLocation("rustic:blocks/fluids/booze/wildberry_wine_flow")){

            @Override
            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    for (PotionEffect effect : player.func_70651_bq()) {
                        if (effect.func_188419_a().func_76398_f() || effect.func_76458_c() >= 2) continue;
                        player.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() + 1, effect.func_82720_e(), effect.func_188418_e()));
                    }
                } else {
                    PotionEffect[] effects = player.func_70651_bq().toArray(new PotionEffect[0]);
                    for (int i = 0; i < effects.length; ++i) {
                        PotionEffect effect = effects[i];
                        if (effect.func_188419_a().func_76398_f()) continue;
                        if (effect.func_76458_c() > 0) {
                            player.func_184589_d(effect.func_188419_a());
                            player.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() - 1, effect.func_82720_e(), effect.func_188418_e()));
                            continue;
                        }
                        if (effect.func_76458_c() != 0) continue;
                        player.func_184589_d(effect.func_188419_a());
                    }
                    int duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1034).setViscosity(1500);
        ModFluids.register(WILDBERRY_WINE, false);
        WINE = new FluidBooze("wine", new ResourceLocation("rustic:blocks/fluids/booze/wine_still"), new ResourceLocation("rustic:blocks/fluids/booze/wine_flow")){

            @Override
            protected void affectPlayer(World world, EntityPlayer player, float quality) {
                if (quality >= 0.5f) {
                    float saturation = 2.0f * quality;
                    player.func_71024_bL().func_75122_a(1, saturation);
                    int durationIncrease = (int)(2400.0f * ((quality - 0.5f) * 2.0f));
                    for (PotionEffect effect : player.func_70651_bq()) {
                        if (effect.func_188419_a().func_76398_f() || effect.func_76459_b() >= 12000) continue;
                        int duration = Math.max(Math.min(effect.func_76459_b() + durationIncrease, 12000), effect.func_76459_b());
                        player.func_70690_d(new PotionEffect(effect.func_188419_a(), duration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                    }
                } else {
                    PotionEffect[] effects = player.func_70651_bq().toArray(new PotionEffect[0]);
                    for (int i = 0; i < effects.length; ++i) {
                        PotionEffect effect = effects[i];
                        int durationDecrease = (int)(2400.0 * Math.abs((double)quality - 0.5));
                        if (effect.func_188419_a().func_76398_f()) continue;
                        int duration = effect.func_76459_b() - durationDecrease;
                        if (duration > 0) {
                            player.func_184589_d(effect.func_188419_a());
                            player.func_70690_d(new PotionEffect(effect.func_188419_a(), duration, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                            continue;
                        }
                        player.func_184589_d(effect.func_188419_a());
                    }
                    int duration = (int)(6000.0f * Math.max(1.0f - quality, 0.0f));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration));
                }
            }
        }.setInebriationChance(0.5f).setDensity(1034).setViscosity(1500);
        ModFluids.register(WINE, false);
        BLOCK_OLIVE_OIL = new BlockFluidRustic("olive_oil", OLIVE_OIL, Material.field_151586_h);
        BLOCK_OLIVE_OIL.setQuantaPerBlock(4);
        BLOCK_IRONBERRY_JUICE = new BlockFluidRustic("ironberry_juice", IRONBERRY_JUICE, Material.field_151586_h);
        BLOCK_IRONBERRY_JUICE.setQuantaPerBlock(6);
        BLOCK_WILDBERRY_JUICE = new BlockFluidRustic("wildberry_juice", WILDBERRY_JUICE, Material.field_151586_h);
        BLOCK_WILDBERRY_JUICE.setQuantaPerBlock(6);
        BLOCK_GRAPE_JUICE = new BlockFluidRustic("grape_juice", GRAPE_JUICE, Material.field_151586_h);
        BLOCK_GRAPE_JUICE.setQuantaPerBlock(6);
        BLOCK_APPLE_JUICE = new BlockFluidRustic("apple_juice", APPLE_JUICE, Material.field_151586_h);
        BLOCK_APPLE_JUICE.setQuantaPerBlock(6);
        BLOCK_ALE_WORT = new BlockFluidRustic("ale_wort", ALE_WORT, Material.field_151586_h);
        BLOCK_ALE_WORT.setQuantaPerBlock(4);
        BLOCK_HONEY = new BlockFluidRustic("honey", HONEY, Material.field_151586_h){

            public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
                entity.field_70159_w *= 0.5;
                entity.field_70181_x *= 0.5;
                entity.field_70179_y *= 0.5;
            }
        };
        BLOCK_HONEY.setQuantaPerBlock(2);
    }

    public static void initModels() {
        BLOCK_OLIVE_OIL.initModel();
        BLOCK_IRONBERRY_JUICE.initModel();
        BLOCK_WILDBERRY_JUICE.initModel();
        BLOCK_GRAPE_JUICE.initModel();
        BLOCK_APPLE_JUICE.initModel();
        BLOCK_ALE_WORT.initModel();
        BLOCK_HONEY.initModel();
    }

    private static void register(Fluid fluid) {
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            fluid = FluidRegistry.getFluid((String)fluid.getName());
        }
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        FLUIDS.add(fluid);
    }

    private static void register(Fluid fluid, boolean addBucket) {
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            fluid = FluidRegistry.getFluid((String)fluid.getName());
        }
        if (addBucket) {
            FluidRegistry.addBucketForFluid((Fluid)fluid);
        }
        FLUIDS.add(fluid);
    }

    public static ArrayList<Fluid> getFluids() {
        return new ArrayList<Fluid>(FLUIDS);
    }

    static {
        FLUIDS = new ArrayList<Fluid>();
    }
}

