/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConveyorHandler {
    public static HashMap<ResourceLocation, Class<? extends IConveyorBelt>> classRegistry = new LinkedHashMap<ResourceLocation, Class<? extends IConveyorBelt>>();
    public static HashMap<ResourceLocation, Set<ResourceLocation>> substituteRegistry = new HashMap();
    public static HashMap<ResourceLocation, Function<TileEntity, ? extends IConveyorBelt>> functionRegistry = new LinkedHashMap<ResourceLocation, Function<TileEntity, ? extends IConveyorBelt>>();
    public static HashMap<Class<? extends IConveyorBelt>, ResourceLocation> reverseClassRegistry = new LinkedHashMap<Class<? extends IConveyorBelt>, ResourceLocation>();
    public static Set<BiConsumer<Entity, IConveyorTile>> magnetSupressionFunctions = new HashSet<BiConsumer<Entity, IConveyorTile>>();
    public static Set<BiConsumer<Entity, IConveyorTile>> magnetSupressionReverse = new HashSet<BiConsumer<Entity, IConveyorTile>>();
    public static Block conveyorBlock;
    public static ResourceLocation textureConveyorColour;

    public static <T extends IConveyorBelt> boolean registerConveyorHandler(ResourceLocation key, Class<T> conveyorClass, Function<TileEntity, T> function) {
        if (classRegistry.containsKey(key)) {
            return false;
        }
        classRegistry.put(key, conveyorClass);
        reverseClassRegistry.put(conveyorClass, key);
        functionRegistry.put(key, function);
        return true;
    }

    public static void registerSubstitute(ResourceLocation key, ResourceLocation substitute) {
        Set registeredSubstitutes = substituteRegistry.computeIfAbsent(key, k -> new HashSet());
        registeredSubstitutes.add(substitute);
    }

    public static IConveyorBelt getConveyor(ResourceLocation key, @Nullable TileEntity tile) {
        Function<TileEntity, ? extends IConveyorBelt> func = functionRegistry.get(key);
        if (func != null) {
            return func.apply(tile);
        }
        return null;
    }

    public static ItemStack getConveyorStack(String key) {
        ItemStack stack = new ItemStack(conveyorBlock);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("conveyorType", key);
        return stack;
    }

    public static boolean isConveyor(World world, BlockPos pos, @Nonnull String key, @Nullable EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IConveyorTile)) {
            return false;
        }
        if (facing != null && !facing.equals((Object)((IConveyorTile)tile).getFacing())) {
            return false;
        }
        IConveyorBelt conveyor = ((IConveyorTile)tile).getConveyorSubtype();
        if (conveyor == null) {
            return false;
        }
        ResourceLocation rl = reverseClassRegistry.get(conveyor.getClass());
        if (rl == null) {
            return false;
        }
        ResourceLocation rlKey = new ResourceLocation(key);
        if (key.equalsIgnoreCase(rl.toString())) {
            return true;
        }
        if (substituteRegistry.containsKey(rlKey)) {
            return substituteRegistry.get(rlKey).contains(rl);
        }
        return false;
    }

    public static void registerMagnetSupression(BiConsumer<Entity, IConveyorTile> function, @Nullable BiConsumer<Entity, IConveyorTile> revert) {
        magnetSupressionFunctions.add(function);
        if (revert != null) {
            magnetSupressionReverse.add(revert);
        }
    }

    public static void applyMagnetSupression(Entity entity, IConveyorTile tile) {
        if (entity != null) {
            for (BiConsumer<Entity, IConveyorTile> func : magnetSupressionFunctions) {
                func.accept(entity, tile);
            }
        }
    }

    public static void revertMagnetSupression(Entity entity, IConveyorTile tile) {
        if (entity != null) {
            for (BiConsumer<Entity, IConveyorTile> func : magnetSupressionReverse) {
                func.accept(entity, tile);
            }
        }
    }

    static {
        textureConveyorColour = new ResourceLocation("immersiveengineering:blocks/conveyor_colour");
    }

    public static interface IConveyorTile
    extends IConveyorAttachable {
        public IConveyorBelt getConveyorSubtype();

        public void setConveyorSubtype(IConveyorBelt var1);

        @Override
        default public EnumFacing[] sigOutputDirections() {
            IConveyorBelt subtype = this.getConveyorSubtype();
            if (subtype != null) {
                return subtype.sigTransportDirections((TileEntity)this, this.getFacing());
            }
            return new EnumFacing[0];
        }
    }

    public static interface IConveyorAttachable {
        public EnumFacing getFacing();

        public EnumFacing[] sigOutputDirections();
    }

    public static enum ConveyorDirection {
        HORIZONTAL,
        UP,
        DOWN;

    }

    public static interface IConveyorBelt {
        public static final AxisAlignedBB conveyorBounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        public static final AxisAlignedBB highConveyorBounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.125, 1.0);

        default public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
            String key = reverseClassRegistry.get(this.getClass()).toString();
            key = key + "f" + facing.ordinal();
            key = key + "d" + this.getConveyorDirection().ordinal();
            key = key + "a" + (this.isActive(tile) ? 1 : 0);
            key = key + "w0" + (this.renderWall(tile, facing, 0) ? 1 : 0);
            key = key + "w1" + (this.renderWall(tile, facing, 1) ? 1 : 0);
            key = key + "c" + this.getDyeColour();
            return key;
        }

        default public ConveyorDirection getConveyorDirection() {
            return ConveyorDirection.HORIZONTAL;
        }

        public boolean changeConveyorDirection();

        public boolean setConveyorDirection(ConveyorDirection var1);

        default public void afterRotation(EnumFacing oldDir, EnumFacing newDir) {
        }

        public boolean isActive(TileEntity var1);

        public boolean canBeDyed();

        public boolean setDyeColour(int var1);

        public int getDyeColour();

        default public boolean playerInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing side) {
            return false;
        }

        default public boolean renderWall(TileEntity tile, EnumFacing facing, int wall) {
            if (this.getConveyorDirection() != ConveyorDirection.HORIZONTAL) {
                return true;
            }
            EnumFacing side = wall == 0 ? facing.func_176735_f() : facing.func_176746_e();
            BlockPos pos = tile.func_174877_v().func_177972_a(side);
            TileEntity te = Utils.getExistingTileEntity(tile.func_145831_w(), pos);
            if (te instanceof IConveyorAttachable) {
                boolean b = false;
                for (EnumFacing f : ((IConveyorAttachable)te).sigOutputDirections()) {
                    if (f == side.func_176734_d()) {
                        b = true;
                        continue;
                    }
                    if (f != EnumFacing.UP) continue;
                    b = false;
                }
                return !b;
            }
            te = Utils.getExistingTileEntity(tile.func_145831_w(), pos.func_177982_a(0, -1, 0));
            if (te instanceof IConveyorAttachable) {
                int b = 0;
                for (EnumFacing f : ((IConveyorAttachable)te).sigOutputDirections()) {
                    if (f == side.func_176734_d()) {
                        ++b;
                        continue;
                    }
                    if (f != EnumFacing.UP) continue;
                    ++b;
                }
                return b < 2;
            }
            return true;
        }

        default public EnumFacing[] sigTransportDirections(TileEntity conveyorTile, EnumFacing facing) {
            if (this.getConveyorDirection() == ConveyorDirection.UP) {
                return new EnumFacing[]{facing, EnumFacing.UP};
            }
            if (this.getConveyorDirection() == ConveyorDirection.DOWN) {
                return new EnumFacing[]{facing, EnumFacing.DOWN};
            }
            return new EnumFacing[]{facing};
        }

        default public Vec3d getDirection(TileEntity conveyorTile, Entity entity, EnumFacing facing) {
            ConveyorDirection conveyorDirection = this.getConveyorDirection();
            BlockPos pos = conveyorTile.func_174877_v();
            double vBase = 1.15;
            double vX = 0.1 * vBase * (double)facing.func_82601_c();
            double vY = entity.field_70181_x;
            double vZ = 0.1 * vBase * (double)facing.func_82599_e();
            if (conveyorDirection == ConveyorDirection.UP) {
                vY = 0.17 * vBase;
            } else if (conveyorDirection == ConveyorDirection.DOWN) {
                vY = -0.07 * vBase;
            }
            if (conveyorDirection != ConveyorDirection.HORIZONTAL) {
                entity.field_70122_E = false;
            }
            if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
                if (entity.field_70161_v > (double)pos.func_177952_p() + 0.55) {
                    vZ = -0.1 * vBase;
                } else if (entity.field_70161_v < (double)pos.func_177952_p() + 0.45) {
                    vZ = 0.1 * vBase;
                }
            } else if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                if (entity.field_70165_t > (double)pos.func_177958_n() + 0.55) {
                    vX = -0.1 * vBase;
                } else if (entity.field_70165_t < (double)pos.func_177958_n() + 0.45) {
                    vX = 0.1 * vBase;
                }
            }
            return new Vec3d(vX, vY, vZ);
        }

        default public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
            float heightLimit;
            if (!this.isActive(tile)) {
                return;
            }
            BlockPos pos = tile.func_174877_v();
            ConveyorDirection conveyorDirection = this.getConveyorDirection();
            float f = heightLimit = conveyorDirection == ConveyorDirection.HORIZONTAL ? 0.25f : 1.0f;
            if (!(entity == null || entity.field_70128_L || entity instanceof EntityPlayer && entity.func_70093_af() || !(entity.field_70163_u - (double)pos.func_177956_o() >= 0.0) || !(entity.field_70163_u - (double)pos.func_177956_o() < (double)heightLimit))) {
                boolean contact;
                Vec3d vec = this.getDirection(tile, entity, facing);
                if (entity.field_70143_R < 3.0f) {
                    entity.field_70143_R = 0.0f;
                }
                entity.field_70159_w = vec.field_72450_a;
                entity.field_70181_x = vec.field_72448_b;
                entity.field_70179_y = vec.field_72449_c;
                double distX = Math.abs((double)pos.func_177972_a(facing).func_177958_n() + 0.5 - entity.field_70165_t);
                double distZ = Math.abs((double)pos.func_177972_a(facing).func_177952_p() + 0.5 - entity.field_70161_v);
                double treshold = 0.9;
                boolean bl = facing.func_176740_k() == EnumFacing.Axis.Z ? distZ < treshold : (contact = distX < treshold);
                if (contact && conveyorDirection == ConveyorDirection.UP && !tile.func_145831_w().func_180495_p(pos.func_177972_a(facing).func_177984_a()).func_185913_b()) {
                    double move = 0.4;
                    entity.func_70107_b(entity.field_70165_t + move * (double)facing.func_82601_c(), entity.field_70163_u + 1.0 * move, entity.field_70161_v + move * (double)facing.func_82599_e());
                }
                if (!contact) {
                    ConveyorHandler.applyMagnetSupression(entity, (IConveyorTile)tile);
                } else {
                    BlockPos nextPos = tile.func_174877_v().func_177972_a(facing);
                    if (!(Utils.getExistingTileEntity(tile.func_145831_w(), nextPos) instanceof IConveyorTile)) {
                        ConveyorHandler.revertMagnetSupression(entity, (IConveyorTile)tile);
                    }
                }
                if (entity instanceof EntityItem && entity.field_70173_aa > 1) {
                    ((EntityItem)entity).func_174873_u();
                    this.handleInsertion(tile, (EntityItem)entity, facing, conveyorDirection, distX, distZ);
                }
            }
        }

        default public void onItemDeployed(TileEntity tile, EntityItem entity, EnumFacing facing) {
        }

        default public void handleInsertion(TileEntity tile, EntityItem entity, EnumFacing facing, ConveyorDirection conDir, double distX, double distZ) {
            ItemStack stack;
            boolean contact;
            BlockPos invPos = tile.func_174877_v().func_177972_a(facing).func_177982_a(0, conDir == ConveyorDirection.UP ? 1 : (conDir == ConveyorDirection.DOWN ? -1 : 0), 0);
            World world = tile.func_145831_w();
            TileEntity inventoryTile = Utils.getExistingTileEntity(world, invPos);
            boolean bl = facing.func_176740_k() == EnumFacing.Axis.Z ? distZ < 0.7 : (contact = distX < 0.7);
            if (!tile.func_145831_w().field_72995_K && contact && inventoryTile != null && !(inventoryTile instanceof IConveyorTile) && !(stack = entity.func_92059_d()).func_190926_b()) {
                ItemStack ret = ApiUtils.insertStackIntoInventory(inventoryTile, stack, facing.func_176734_d());
                if (ret.func_190926_b()) {
                    entity.func_70106_y();
                } else if (ret.func_190916_E() < stack.func_190916_E()) {
                    entity.func_92058_a(ret);
                }
            }
        }

        default public boolean isTicking(TileEntity tile) {
            return false;
        }

        default public void onUpdate(TileEntity tile, EnumFacing facing) {
        }

        default public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
            return this.getConveyorDirection() == ConveyorDirection.HORIZONTAL ? Lists.newArrayList((Object[])new AxisAlignedBB[]{conveyorBounds}) : Lists.newArrayList((Object[])new AxisAlignedBB[]{highConveyorBounds});
        }

        default public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{conveyorBounds});
        }

        public NBTTagCompound writeConveyorNBT();

        public void readConveyorNBT(NBTTagCompound var1);

        @SideOnly(value=Side.CLIENT)
        default public Matrix4f modifyBaseRotationMatrix(Matrix4f matrix, @Nullable TileEntity tile, EnumFacing facing) {
            return matrix;
        }

        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getActiveTexture();

        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getInactiveTexture();

        @SideOnly(value=Side.CLIENT)
        default public ResourceLocation getColouredStripesTexture() {
            return textureConveyorColour;
        }

        @SideOnly(value=Side.CLIENT)
        default public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
            return baseModel;
        }
    }
}

