/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import ipsis.woot.plugins.thauncraft.Thaumcraft;
import net.minecraft.util.ResourceLocation;

public class WootMobName {
    private String entityKey = "INVALID";
    private String tag = "";
    private String name;

    public String getEntityKey() {
        return this.entityKey;
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    private void createName() {
        this.name = this.tag.equals("") ? this.entityKey : this.entityKey + "," + this.tag;
    }

    public WootMobName() {
        this.createName();
    }

    public String toString() {
        return this.name;
    }

    public WootMobName(String entityKey, String tag) {
        this.entityKey = entityKey;
        this.tag = tag;
        this.createName();
    }

    public WootMobName(String entityKey) {
        this.entityKey = entityKey;
        this.tag = "";
        this.createName();
    }

    public boolean isValid() {
        return !this.entityKey.equals("INVALID");
    }

    public boolean isEnderDragon() {
        return this.entityKey.equalsIgnoreCase("minecraft:ender_dragon");
    }

    public boolean isChaosGuardian() {
        return this.entityKey.equalsIgnoreCase("draconicevolution:chaosguardian");
    }

    public boolean isThaumcraftWisp() {
        return this.entityKey.equalsIgnoreCase(Thaumcraft.getWispName());
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.entityKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WootMobName that = (WootMobName)o;
        if (!this.entityKey.equalsIgnoreCase(that.entityKey)) {
            return false;
        }
        if (!this.tag.equals("") && !this.tag.equalsIgnoreCase(that.tag)) {
            return false;
        }
        return this.name.equalsIgnoreCase(that.name);
    }

    public int hashCode() {
        int result = this.entityKey.hashCode();
        result = 31 * result + this.tag.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

