/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.plugins.thauncraft;

import ipsis.Woot;
import ipsis.woot.plugins.thauncraft.Aspect;
import ipsis.woot.plugins.thauncraft.AspectList;
import ipsis.woot.util.EnumEnchantKey;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Thaumcraft {
    public static final String THAUMCRAFT_MODID = "thaumcraft";
    private static final String CRYSTAL_NAME = "crystal_essence";
    private static final String WISP_NAME = "wisp";
    public static Item crystal = null;

    @Optional.Method(modid="thaumcraft")
    public static void init() {
        crystal = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(THAUMCRAFT_MODID, CRYSTAL_NAME));
    }

    public static ItemStack makeCrystal(Aspect aspect, int stackSize) {
        if (aspect == null || crystal == null) {
            return null;
        }
        ItemStack is = new ItemStack(crystal, stackSize, 0);
        Thaumcraft.setAspects(is, new AspectList().add(aspect, 1));
        return is;
    }

    public static ItemStack makeCrystal(Aspect aspect) {
        return Thaumcraft.makeCrystal(aspect, 1);
    }

    private static void setAspects(ItemStack itemStack, AspectList aspects) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        aspects.writeToNBT(itemStack.func_77978_p());
    }

    public static boolean isThaumcraftCrystal(ItemStack itemStack) {
        if (itemStack.func_190926_b() || crystal == null) {
            return false;
        }
        return itemStack.func_77973_b() == crystal;
    }

    public static String getWispName() {
        return "thaumcraft:wisp";
    }

    public static ItemStack getCrystal(EnumEnchantKey key) {
        Aspect aspect = null;
        ArrayList<Aspect> aspects = null;
        int primalChance = 90;
        if (key == EnumEnchantKey.LOOTING_I) {
            primalChance = 80;
        } else if (key == EnumEnchantKey.LOOTING_II) {
            primalChance = 60;
        } else if (key == EnumEnchantKey.LOOTING_III) {
            primalChance = 50;
        }
        int roll = Woot.RANDOM.nextInt(100) + 1;
        aspects = roll <= primalChance ? Aspect.getPrimalAspects() : Aspect.getCompoundAspects();
        aspect = aspects.get(Woot.RANDOM.nextInt(aspects.size()));
        return Thaumcraft.makeCrystal(aspect);
    }
}

