/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.handler;

import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.configuration.loaders.ConfigurationLoader;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigHandler.loadConfiguration();
        }
    }

    public static void saveDimensionId(int id) {
        EnumConfigKey key = EnumConfigKey.TARTARUS_ID;
        Woot.wootConfiguration.setInteger(key, id);
        configuration.get("general", key.getText(), key.getDefaultBoolean(), key.getComment()).set(id);
        configuration.save();
    }

    static void loadConfiguration() {
        ConfigurationLoader.load(configuration, Woot.wootConfiguration);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("woot")) {
            ConfigHandler.loadConfiguration();
        }
    }
}

