/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.PropertyMaterial;
import org.cyclops.colossalchests.client.render.tileentity.RenderTileEntityColossalChest;
import org.cyclops.colossalchests.item.ItemBlockMaterial;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockContainerConfig;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;

public class ColossalChestConfig
extends BlockContainerConfig {
    public static ColossalChestConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The maximum size a colossal chest can have.", isCommandable=true)
    public static int maxSize;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If the chest should visually open when someone uses it.", isCommandable=true)
    public static boolean chestAnimation;

    public ColossalChestConfig() {
        super((ModBase)ColossalChests._instance, true, "colossal_chest", null, ColossalChest.class);
    }

    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockMaterial.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        ModelChest model = new ModelChest();
        ColossalChests._instance.getProxy().registerRenderer(TileColossalChest.class, (TileEntitySpecialRenderer)new RenderTileEntityColossalChest(model));
    }

    @SideOnly(value=Side.CLIENT)
    public static void onInit(IInitListener.Step step, BlockConfig blockConfig) {
        for (PropertyMaterial.Type material : PropertyMaterial.Type.values()) {
            Item item = Item.func_150898_a((Block)blockConfig.getBlockInstance());
            String modId = blockConfig.getMod().getModId();
            int meta = material.ordinal();
            String itemName = blockConfig.getModelName(new ItemStack(item, 1, meta));
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(modId + ":" + itemName, "inventory")});
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation(modId + ":" + itemName, "inventory"));
        }
    }

    public static String getModelNameSuffix(ItemStack itemStack) {
        return "_" + PropertyMaterial.Type.values()[itemStack.func_77952_i()].toString().toLowerCase(Locale.ENGLISH);
    }

    @SideOnly(value=Side.CLIENT)
    public void onInit(IInitListener.Step step) {
        super.onInit(step);
        if (step == IInitListener.Step.INIT) {
            ColossalChestConfig.onInit(step, (BlockConfig)this);
        }
    }

    public String getModelName(ItemStack itemStack) {
        return super.getModelName(itemStack) + ColossalChestConfig.getModelNameSuffix(itemStack);
    }

    static {
        maxSize = 20;
        chestAnimation = true;
    }
}

