/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.google.common.io.Files;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.util.ChunkDataHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackUpHelper {
    private BackUpHelper() {
    }

    public static boolean backupColonyData() {
        BackUpHelper.saveColonies(true);
        try (FileOutputStream fos = new FileOutputStream(BackUpHelper.getBackupSaveLocation(new Date()));){
            File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int dim = 0; dim < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++dim) {
                for (int i = 1; i <= ColonyManager.getTopColonyId() + 1; ++i) {
                    File file = new File(saveDir, String.format("colony%d_%d.dat", i, dim));
                    if (!file.exists()) continue;
                    BackUpHelper.addToZipFile(String.format("colony%d_%d.dat", i, dim), zos, saveDir);
                }
            }
            BackUpHelper.addToZipFile(BackUpHelper.getSaveLocation().getName(), zos, saveDir);
            zos.close();
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to backup colony data, please contact an administrator", (Throwable)e);
            return false;
        }
        return true;
    }

    @NotNull
    private static File getBackupSaveLocation(Date date) {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        return new File(saveDir, String.format("colonies-%s.zip", new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(date)));
    }

    private static void addToZipFile(String fileName, ZipOutputStream zos, File folder) {
        File file = new File(folder, fileName);
        try (FileInputStream fis = new FileInputStream(file);){
            zos.putNextEntry(new ZipEntry(fileName));
            Files.copy((File)file, (OutputStream)zos);
        }
        catch (Exception e) {
            Log.getLogger().warn("Error packing " + fileName + " into the zip.");
        }
    }

    @NotNull
    public static File getSaveLocation() {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        return new File(saveDir, "colonies.dat");
    }

    public static void saveNBTToPath(@Nullable File file, @NotNull NBTTagCompound compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.func_74793_a((NBTTagCompound)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static NBTTagCompound loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading file from path in ColonyManager!", (Throwable)exception);
        }
        return null;
    }

    public static void saveColonies(boolean isWorldUnload) {
        NBTTagCompound compound = new NBTTagCompound();
        ColonyManager.writeToNBT(compound);
        File file = BackUpHelper.getSaveLocation();
        BackUpHelper.saveNBTToPath(file, compound);
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        for (Colony colony : ColonyManager.getAllColonies()) {
            NBTTagCompound colonyCompound = new NBTTagCompound();
            colony.writeToNBT(colonyCompound);
            BackUpHelper.saveNBTToPath(new File(saveDir, String.format("colony%d_%d.dat", colony.getID(), colony.getDimension())), colonyCompound);
        }
    }

    public static void loadColonyBackup(int colonyId, int dimension) {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        NBTTagCompound compound = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format("colony%d_%d.dat", colonyId, dimension)));
        if (compound == null) {
            Log.getLogger().warn("Can't find NBT of colony: " + colonyId + " at location: " + new File(saveDir, String.format("colony%d_%d.dat", colonyId, dimension).toString()));
            return;
        }
        Colony colony = ColonyManager.getColonyByDimension(colonyId, dimension);
        if (colony != null) {
            colony.readFromNBT(compound);
        } else {
            Log.getLogger().warn("Colony is null, creating new colony!");
            WorldServer colonyWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
            colony = Colony.loadColony(compound, (World)colonyWorld);
            ((IColonyManagerCapability)colonyWorld.getCapability(MineColonies.COLONY_MANAGER_CAP, null)).addColony(colony);
            if (Configurations.gameplay.enableDynamicColonySizes) {
                for (AbstractBuilding building : colony.getBuildingManager().getBuildings().values()) {
                    ChunkDataHelper.claimColonyChunks((World)colonyWorld, true, colony.getID(), building.getLocation(), colony.getDimension(), building.getClaimRadius(building.getBuildingLevel()));
                }
            } else {
                ChunkDataHelper.claimColonyChunks((World)colonyWorld, true, colony.getID(), colony.getCenter(), colony.getDimension());
            }
        }
        Log.getLogger().warn("Successfully restored colony!");
    }
}

