/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.sounds;

import com.minecolonies.coremod.sounds.AbstractWorkerSounds;
import com.minecolonies.coremod.sounds.ModSoundEvents;
import com.minecolonies.coremod.util.SoundUtils;
import java.util.Random;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class BuilderSounds
extends AbstractWorkerSounds {
    private static final int NUMBER_OF_SOUNDS = 3;
    private static final Random rand = new Random();

    @Override
    public void playSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (!isFemale) {
            return;
        }
        switch (rand.nextInt(4)) {
            case 1: {
                SoundEvent noises = Female.noises;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, noises, this.getBasicSoundChance());
                break;
            }
            case 2: {
                this.playSaturationSound(worldIn, position, isFemale, saturation);
                break;
            }
            default: {
                SoundEvent generalPhrases = Female.generalPhrases;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, generalPhrases, this.getPhraseChance());
            }
        }
    }

    @Override
    public String getWorkerString() {
        return "Builder";
    }

    @Override
    public void playInteractionSound(World worldIn, BlockPos position, boolean isFemale) {
        if (!isFemale) {
            return;
        }
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, Female.interaction, this.getBasicSoundChance());
    }

    public void playSaturationSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        SoundEvent saturationFeedback;
        if (!isFemale) {
            return;
        }
        if (saturation < 3.0) {
            saturationFeedback = Female.saturationVeryLow;
        } else if (saturation < 5.0) {
            saturationFeedback = Female.saturationLow;
        } else {
            return;
        }
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, saturationFeedback, this.getBasicSoundChance());
    }

    public static final class Male {
        private Male() {
        }
    }

    public static final class Female {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.builder.female.generalPhrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.builder.female.noise");
        public static final SoundEvent hostile = ModSoundEvents.getSoundID("mob.builder.female.hostile");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.builder.female.offToBed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.builder.female.badWeather");
        public static final SoundEvent saturationVeryLow = ModSoundEvents.getSoundID("mob.builder.female.saturationVeryLow");
        public static final SoundEvent saturationLow = ModSoundEvents.getSoundID("mob.builder.female.saturationLow");
        public static final SoundEvent greeting = ModSoundEvents.getSoundID("mob.builder.female.greeting");
        public static final SoundEvent farewell = ModSoundEvents.getSoundID("mob.builder.female.farewell");
        public static final SoundEvent interaction = ModSoundEvents.getSoundID("mob.builder.female.interaction");
        public static final SoundEvent complete = ModSoundEvents.getSoundID("mob.builder.female.complete");

        private Female() {
        }
    }
}

