/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class UpdateRequestStateMessage
extends AbstractMessage<UpdateRequestStateMessage, IMessage> {
    private int colonyId;
    private IToken token;
    private ItemStack itemStack = ItemStackUtils.EMPTY;
    private RequestState state;
    private int dimension;

    public UpdateRequestStateMessage() {
    }

    public UpdateRequestStateMessage(int colonyId, IToken requestId, RequestState state, ItemStack itemStack) {
        this.colonyId = colonyId;
        this.token = requestId;
        this.state = state;
        this.itemStack = itemStack;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.token = (IToken)StandardFactoryController.getInstance().deserialize(ByteBufUtils.readTag((ByteBuf)buf));
        this.state = RequestState.values()[buf.readInt()];
        if (this.state == RequestState.OVERRULED) {
            this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)StandardFactoryController.getInstance().serialize(this.token));
        buf.writeInt(this.state.ordinal());
        if (this.state == RequestState.OVERRULED) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
        }
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(UpdateRequestStateMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColonyByDimension(message.colonyId, message.dimension);
        if (colony instanceof Colony) {
            if (message.state == RequestState.OVERRULED) {
                colony.getRequestManager().overruleRequest(message.token, message.itemStack);
                return;
            }
            colony.getRequestManager().updateRequestState(message.token, message.state);
        }
    }
}

