/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class DirectPlaceMessage
extends AbstractMessage<DirectPlaceMessage, IMessage> {
    private IBlockState state;
    private BlockPos pos;
    private ItemStack stack;

    public DirectPlaceMessage() {
    }

    public DirectPlaceMessage(IBlockState state, BlockPos pos, ItemStack stack) {
        this.state = state;
        this.pos = pos;
        this.stack = stack;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.state = NBTUtil.func_190008_d((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        this.pos = BlockPosUtil.readFromByteBuf(buf);
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.state));
        BlockPosUtil.writeToByteBuf(buf, this.pos);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    @Override
    public void messageOnServerThread(DirectPlaceMessage message, EntityPlayerMP player) {
        WorldServer world = player.func_71121_q();
        Colony colony = ColonyManager.getColonyByPosFromWorld((World)world, message.pos);
        if (colony == null || colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            player.func_71121_q().func_175656_a(message.pos, message.state);
            InventoryUtils.reduceStackInItemHandler(new InvWrapper((IInventory)player.field_71071_by), message.stack);
            message.state.func_177230_c().func_180633_a((World)world, message.pos, message.state, (EntityLivingBase)player, message.stack);
        }
    }
}

