/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewWorkOrderMessage
extends AbstractMessage<ColonyViewWorkOrderMessage, IMessage> {
    private int colonyId;
    private int workOrderId;
    private ByteBuf workOrderBuffer;

    public ColonyViewWorkOrderMessage() {
    }

    public ColonyViewWorkOrderMessage(@NotNull Colony colony, @NotNull AbstractWorkOrder workOrder) {
        this.colonyId = colony.getID();
        this.workOrderBuffer = Unpooled.buffer();
        this.workOrderId = workOrder.getID();
        workOrder.serializeViewNetworkData(this.workOrderBuffer);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        ByteBuf newbuf = buf.retain();
        this.colonyId = newbuf.readInt();
        this.workOrderId = newbuf.readInt();
        this.workOrderBuffer = newbuf;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.workOrderId);
        buf.writeBytes(this.workOrderBuffer);
    }

    @Override
    protected void messageOnClientThread(ColonyViewWorkOrderMessage message, MessageContext ctx) {
        ColonyManager.handleColonyViewWorkOrderMessage(message.colonyId, message.workOrderBuffer, Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
    }
}

