/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizenhandlers;

import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.entity.AbstractEntityCitizen;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.Optional;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenColonyHandler {
    private final EntityCitizen citizen;
    private int colonyId;
    @Nullable
    private Colony colony;

    public CitizenColonyHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Nullable
    public AbstractBuildingWorker getWorkBuilding() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getWorkBuilding();
    }

    public void initEntityCitizenValues(@Nullable Colony c, @Nullable CitizenData data) {
        if (c == null) {
            this.colony = null;
            this.colonyId = 0;
            this.citizen.setCitizenId(0);
            this.citizen.setCitizenData(null);
            this.citizen.func_70106_y();
            return;
        }
        this.colony = c;
        this.colonyId = this.colony.getID();
        this.citizen.setCitizenId(data.getId());
        this.citizen.setCitizenData(data);
        this.citizen.setIsChild(data.isChild());
        this.citizen.func_96094_a(this.citizen.getCitizenData().getName());
        this.citizen.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(data.getMaxHealth());
        this.citizen.func_70606_j((float)data.getHealth());
        this.citizen.setFemale(this.citizen.getCitizenData().isFemale());
        this.citizen.setTextureId(this.citizen.getCitizenData().getTextureId());
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_COLONY_ID, (Object)this.colonyId);
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_CITIZEN_ID, (Object)this.citizen.getCitizenId());
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_FEMALE, (Object)(this.citizen.isFemale() ? 1 : 0));
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_TEXTURE, (Object)this.citizen.getTextureId());
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_ASLEEP, (Object)this.citizen.getCitizenData().isAsleep());
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_CHILD, (Object)this.citizen.getCitizenData().isChild());
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_BED_POS, (Object)this.citizen.getCitizenData().getBedPos());
        this.citizen.getCitizenExperienceHandler().updateLevel();
        this.citizen.getCitizenData().setCitizenEntity(this.citizen);
        this.citizen.getCitizenData().setLastPosition(this.citizen.func_180425_c());
        this.citizen.getCitizenJobHandler().onJobChanged(this.citizen.getCitizenJobHandler().getColonyJob());
    }

    @Nullable
    public AbstractBuilding getHomeBuilding() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getHomeBuilding();
    }

    public void updateColonyServer() {
        if (this.colonyId == 0) {
            Colony colony = ColonyManager.getColonyByPosFromWorld(this.citizen.func_130014_f_(), this.citizen.func_180425_c());
            if (colony == null) {
                this.citizen.func_70106_y();
            } else {
                this.colonyId = colony.getID();
                this.handleNullColony();
            }
            return;
        }
        if (this.colony == null) {
            this.handleNullColony();
        }
    }

    private void handleNullColony() {
        Colony c = ColonyManager.getColonyByWorld(this.colonyId, this.citizen.field_70170_p);
        if (c == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' unable to find Colony #%d", this.citizen.func_110124_au(), this.colonyId));
            this.citizen.func_70106_y();
            return;
        }
        CitizenData data = c.getCitizenManager().getCitizen(this.citizen.getCitizenId());
        if (data == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' attempting to register with Colony #%d as Citizen %d, but not known to colony", this.citizen.func_110124_au(), this.colonyId, this.citizen.getCitizenId()));
            this.citizen.func_70106_y();
            return;
        }
        Optional<EntityCitizen> entityCitizenOptional = data.getCitizenEntity();
        entityCitizenOptional.filter(entityCitizen -> !this.citizen.func_110124_au().equals(entityCitizen.func_110124_au())).ifPresent(entityCitizen -> this.handleExistingCitizen(data, (EntityCitizen)((Object)entityCitizen)));
        this.initEntityCitizenValues(c, data);
    }

    private void handleExistingCitizen(@NotNull CitizenData data, @NotNull EntityCitizen existingCitizen) {
        Log.getLogger().warn(String.format("EntityCitizen '%s' attempting to register with Colony #%d as Citizen #%d, but already have a citizen ('%s')", this.citizen.func_110124_au(), this.colonyId, this.citizen.getCitizenId(), existingCitizen.func_110124_au()));
        if (existingCitizen.func_110124_au().equals(this.citizen.func_110124_au())) {
            data.setCitizenEntity(this.citizen);
        } else {
            this.citizen.func_70106_y();
        }
    }

    public void updateColonyClient() {
        if (this.citizen.func_184212_Q().func_187223_a()) {
            if (this.colonyId == 0) {
                this.colonyId = (Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_COLONY_ID);
            }
            if (this.citizen.getCitizenId() == 0) {
                this.citizen.setCitizenId((Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_CITIZEN_ID));
            }
            this.citizen.setFemale((Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_IS_FEMALE) != 0);
            this.citizen.setIsChild((Boolean)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_IS_CHILD));
            this.citizen.getCitizenExperienceHandler().setLevel((Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_LEVEL));
            this.citizen.setModelId(RenderBipedCitizen.Model.valueOf((String)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_MODEL)));
            this.citizen.setTextureId((Integer)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_TEXTURE));
            this.citizen.setRenderMetadata((String)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_RENDER_METADATA));
            this.citizen.setTexture();
            this.citizen.func_184212_Q().func_187230_e();
        }
        this.citizen.updateArmSwingProg();
    }

    public double getPerBuildingFoodCost() {
        return this.getWorkBuilding() == null || this.getWorkBuilding().getBuildingLevel() == 0 ? 1.0 : 0.02 * Math.pow(2.0, this.getWorkBuilding().getBuildingLevel());
    }

    @Nullable
    public Colony getColony() {
        return this.colony;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public void setColonyId(int colonyId) {
        this.colonyId = colonyId;
    }

    public void clearColony() {
        this.initEntityCitizenValues(null, null);
    }

    public boolean isAtHome() {
        AbstractBuilding homeBuilding = this.getHomeBuilding();
        if (homeBuilding instanceof BuildingHome) {
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = homeBuilding.getCorners();
            return new AxisAlignedBB((double)((Integer)((Tuple)corners.func_76341_a()).func_76341_a()).intValue(), this.citizen.field_70163_u - 1.0, (double)((Integer)((Tuple)corners.func_76340_b()).func_76341_a()).intValue(), (double)((Integer)((Tuple)corners.func_76341_a()).func_76340_b()).intValue(), this.citizen.field_70163_u + 1.0, (double)((Integer)((Tuple)corners.func_76340_b()).func_76340_b()).intValue()).func_186667_c(new Vec3d((Vec3i)this.citizen.func_180425_c()));
        }
        BlockPos homePosition = this.citizen.func_180486_cf();
        return homePosition.func_177954_c((double)((int)Math.floor(this.citizen.field_70165_t)), (double)((int)this.citizen.field_70163_u), (double)((int)Math.floor(this.citizen.field_70161_v))) <= 16.0;
    }
}

