/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.mobs.aitasks;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.entity.ai.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.entity.pathfinding.GeneralEntityWalkToProxy;
import com.minecolonies.coremod.entity.pathfinding.PathResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EntityAIWalkToRandomHuts
extends EntityAIBase {
    protected final AbstractEntityMinecoloniesMob entity;
    private final List<EnumFacing> directions = Arrays.asList(Arrays.copyOf(EnumFacing.field_176754_o, 4));
    protected final World world;
    protected final double speed;
    private final Random random = new Random();
    private BlockPos targetBlock;
    private GeneralEntityWalkToProxy proxy;
    private BlockPos lastPos = null;
    private int stuckTime = 1;
    private int notStuckTime = 0;
    private int passedTicks = 0;
    private PathResult moveAwayPath;

    public EntityAIWalkToRandomHuts(AbstractEntityMinecoloniesMob creatureIn, double speedIn) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.world = creatureIn.func_130014_f_();
        this.lastPos = this.entity.func_180425_c();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.targetBlock == null) {
            this.targetBlock = this.getRandomBuilding();
        }
        return this.targetBlock != null;
    }

    public boolean func_75253_b() {
        return !this.entity.getNavigator().func_75500_f() && this.entity.func_70089_S();
    }

    public void func_75249_e() {
        if (this.targetBlock != null) {
            if (this.isEntityAtSiteWithMove(this.targetBlock, 2)) {
                this.targetBlock = this.getRandomBuilding();
            }
        } else {
            this.targetBlock = this.getRandomBuilding();
        }
        this.lastPos = this.entity.func_180425_c();
    }

    private boolean isEntityAtSiteWithMove(@NotNull BlockPos site, int range) {
        BlockPos front;
        ++this.passedTicks;
        if (this.proxy == null) {
            this.proxy = new GeneralEntityWalkToProxy((EntityLiving)this.entity);
        }
        if (this.passedTicks % 20 != 0) {
            return this.proxy.walkToBlock(site, range, true);
        }
        this.passedTicks = 0;
        if (new AxisAlignedBB(this.entity.func_180425_c()).func_72321_a(1.0, 1.0, 1.0).func_72321_a(-1.0, -1.0, -1.0).func_72326_a(new AxisAlignedBB(this.lastPos))) {
            front = this.entity.func_180425_c().func_177977_b().func_177972_a(this.entity.func_174811_aO());
            AxisAlignedBB collisionBox = this.world.func_180495_p(this.entity.func_180425_c()).func_185890_d((IBlockAccess)this.world, this.entity.func_180425_c());
            if (!this.world.func_180495_p(front).func_185904_a().func_76220_a() || this.world.func_180495_p(this.entity.func_180425_c().func_177984_a().func_177972_a(this.entity.func_174811_aO())).func_185904_a().func_76220_a() || collisionBox != null && collisionBox.field_72337_e > 1.0) {
                ++this.stuckTime;
            } else {
                ++this.notStuckTime;
            }
        } else {
            this.stuckTime = 0;
            ++this.notStuckTime;
        }
        this.lastPos = this.entity.func_180425_c();
        if (this.notStuckTime > 1) {
            this.entity.setStuckCounter(0);
            this.entity.setLadderCounter(0);
            this.notStuckTime = 0;
            this.stuckTime = 0;
            return true;
        }
        if (this.stuckTime > 2) {
            this.entity.getNavigator().func_75499_g();
            this.entity.setStuckCounter(this.entity.getStuckCounter() + 1);
            front = this.entity.func_180425_c().func_177977_b().func_177972_a(this.entity.func_174811_aO());
            if (this.world.func_175623_d(front) || this.world.func_180495_p(front).func_177230_c() == Blocks.field_150353_l || this.world.func_180495_p(front).func_177230_c() == Blocks.field_150356_k) {
                this.notStuckTime = 0;
                this.world.func_175656_a(front, Blocks.field_150347_e.func_176223_P());
            }
            if (this.entity.getStuckCounter() > 1 && Configurations.gameplay.doBarbariansBreakThroughWalls) {
                Collections.shuffle(this.directions);
                this.entity.setLadderCounter(this.entity.getLadderCounter() + 1);
                this.notStuckTime = 0;
                IBlockState ladderHere = this.world.func_180495_p(this.entity.func_180425_c());
                IBlockState ladderUp = this.world.func_180495_p(this.entity.func_180425_c().func_177984_a());
                if (this.entity.getLadderCounter() <= 10 || this.random.nextBoolean()) {
                    if (ladderHere.func_177230_c() == Blocks.field_150468_ap && ladderUp.func_177230_c() != Blocks.field_150468_ap && !ladderHere.func_185904_a().func_76224_d()) {
                        this.world.func_175656_a(this.entity.func_180425_c().func_177984_a(), ladderHere);
                    } else if (ladderUp.func_177230_c() == Blocks.field_150468_ap && ladderHere.func_177230_c() != Blocks.field_150468_ap && !ladderUp.func_185904_a().func_76224_d()) {
                        this.world.func_175656_a(this.entity.func_180425_c(), ladderUp);
                    } else if (ladderUp.func_177230_c() != Blocks.field_150468_ap && ladderHere.func_177230_c() != Blocks.field_150468_ap) {
                        for (EnumFacing dir : this.directions) {
                            if (!this.world.func_180495_p(this.entity.func_180425_c().func_177972_a(dir)).func_185904_a().func_76220_a()) continue;
                            if (this.random.nextBoolean()) {
                                this.world.func_175656_a(this.entity.func_180425_c().func_177984_a(), Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)dir.func_176734_d()));
                            } else if (!ladderHere.func_185904_a().func_76224_d()) {
                                this.world.func_175656_a(this.entity.func_180425_c(), Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)dir.func_176734_d()));
                            }
                            break;
                        }
                    }
                } else {
                    for (EnumFacing dir : this.directions) {
                        BlockPos posToDestroy;
                        IBlockState state = this.world.func_180495_p(this.entity.func_180425_c().func_177972_a(dir));
                        if ((!state.func_185904_a().func_76220_a() || state.func_177230_c() == Blocks.field_150468_ap) && !(state.func_177230_c() instanceof BlockDoor)) continue;
                        switch (this.random.nextInt(4)) {
                            case 1: {
                                posToDestroy = this.entity.func_180425_c().func_177972_a(dir).func_177984_a();
                                break;
                            }
                            case 2: {
                                posToDestroy = this.entity.func_180425_c().func_177972_a(dir);
                                break;
                            }
                            default: {
                                posToDestroy = this.entity.func_180425_c().func_177981_b(2);
                            }
                        }
                        this.world.func_175655_b(posToDestroy, true);
                        break;
                    }
                }
            } else if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
                this.moveAwayPath = this.entity.getNavigator().moveAwayFromXYZ(this.entity.func_180425_c(), this.random.nextInt(4), 2.0);
            }
            return false;
        }
        return this.proxy.walkToBlock(site, range, true);
    }

    private BlockPos getRandomBuilding() {
        if (this.entity.getColony() == null) {
            return null;
        }
        Collection<AbstractBuilding> buildingList = this.entity.getColony().getBuildingManager().getBuildings().values();
        Object[] buildingArray = buildingList.toArray();
        if (buildingArray.length != 0) {
            int rand = this.random.nextInt(buildingArray.length);
            AbstractBuilding building = (AbstractBuilding)buildingArray[rand];
            return building.getLocation();
        }
        return null;
    }
}

