/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseRequestResolver;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class WarehouseRequestResolverFactory
implements IRequestResolverFactory<WarehouseRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends WarehouseRequestResolver> getFactoryOutputType() {
        return TypeToken.of(WarehouseRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public WarehouseRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new WarehouseRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull WarehouseRequestResolver warehouseRequestResolver) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(NBT_TOKEN, (NBTBase)controller.serialize(warehouseRequestResolver.getRequesterId()));
        compound.func_74782_a(NBT_LOCATION, (NBTBase)controller.serialize(warehouseRequestResolver.getRequesterLocation()));
        return compound;
    }

    @Override
    @NotNull
    public WarehouseRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        return new WarehouseRequestResolver(location, token);
    }
}

