/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.StandardPlayerRequestResolver;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class StandardPlayerRequestResolverFactory
implements IFactory<IRequestManager, StandardPlayerRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_ASSIGNED_REQUESTS = "Requests";
    private static final Integer CONST_PLAYER_RESOLVER_ID_SCALE = -1;

    @Override
    @NotNull
    public TypeToken<? extends StandardPlayerRequestResolver> getFactoryOutputType() {
        return TypeToken.of(StandardPlayerRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends IRequestManager> getFactoryInputType() {
        return TypeToken.of(IRequestManager.class);
    }

    @Override
    @NotNull
    public StandardPlayerRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull IRequestManager iRequestManager, Object ... context) throws IllegalArgumentException {
        ILocation location = factoryController.getNewInstance(TypeConstants.ILOCATION, iRequestManager.getColony().getCenter(), iRequestManager.getColony().getDimension());
        IToken token = factoryController.getNewInstance(TypeConstants.ITOKEN, iRequestManager.getColony().getID() * CONST_PLAYER_RESOLVER_ID_SCALE, new Object[0]);
        return new StandardPlayerRequestResolver(location, token);
    }

    @Override
    @NotNull
    public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull StandardPlayerRequestResolver playerRequestResolver) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(NBT_TOKEN, (NBTBase)controller.serialize(playerRequestResolver.getRequesterId()));
        compound.func_74782_a(NBT_LOCATION, (NBTBase)controller.serialize(playerRequestResolver.getRequesterLocation()));
        compound.func_74782_a(NBT_ASSIGNED_REQUESTS, (NBTBase)playerRequestResolver.getAllAssignedRequests().stream().map(controller::serialize).collect(NBTUtils.toNBTTagList()));
        return compound;
    }

    @Override
    @NotNull
    public StandardPlayerRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) {
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        Set<IToken<?>> assignedRequests = NBTUtils.streamCompound(nbt.func_150295_c(NBT_ASSIGNED_REQUESTS, 10)).map(c -> (IToken)controller.deserialize((NBTTagCompound)c)).collect(Collectors.toSet());
        StandardPlayerRequestResolver resolver = new StandardPlayerRequestResolver(location, token);
        resolver.setAllAssignedRequests(assignedRequests);
        return resolver;
    }
}

