/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.handlers;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.LogHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.RequestHandler;
import com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped.WrappedStaticStateRequestManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ResolverHandler {
    public static Collection<IToken<?>> registerResolvers(IStandardRequestManager manager, IRequestResolver<?> ... resolvers) {
        return Arrays.stream(resolvers).map(resolver -> ResolverHandler.registerResolver(manager, resolver)).collect(Collectors.toList());
    }

    public static IToken<?> registerResolver(IStandardRequestManager manager, IRequestResolver<? extends IRequestable> resolver) {
        if (manager.getRequestResolverIdentitiesDataStore().getIdentities().containsKey(resolver.getRequesterId())) {
            throw new IllegalArgumentException("The token attached to this resolver is already registered. Cannot register twice!");
        }
        if (manager.getRequestResolverIdentitiesDataStore().getIdentities().containsValue(resolver)) {
            throw new IllegalArgumentException("The given resolver is already registered with a different token. Cannot register twice!");
        }
        manager.getRequestResolverIdentitiesDataStore().getIdentities().put(resolver.getRequesterId(), resolver);
        Set<TypeToken> resolverTypes = ReflectionUtils.getSuperClasses(resolver.getRequestType());
        resolverTypes.remove(TypeConstants.OBJECT);
        resolverTypes.forEach(c -> {
            if (!manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().containsKey(c)) {
                manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().put((TypeToken)c, new ArrayList());
            }
            LogHandler.log("Registering resolver: " + resolver + " with request type: " + c);
            manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().get(c).add(resolver.getRequesterId());
        });
        return resolver.getRequesterId();
    }

    public static Collection<IToken<?>> registerResolvers(IStandardRequestManager manager, Collection<IRequestResolver<?>> resolvers) {
        return resolvers.stream().map(resolver -> ResolverHandler.registerResolver(manager, resolver)).collect(Collectors.toList());
    }

    public static void removeResolver(IStandardRequestManager manager, IToken<?> token) {
        if (!manager.getRequestResolverIdentitiesDataStore().getIdentities().containsKey(token)) {
            throw new IllegalArgumentException("The token is unknown to this manager.");
        }
        ResolverHandler.removeResolver(manager, ResolverHandler.getResolver(manager, token));
    }

    public static void removeResolver(IStandardRequestManager manager, IRequestResolver<?> resolver) {
        IRequestResolver<? extends IRequestable> registeredResolver = ResolverHandler.getResolver(manager, resolver.getRequesterId());
        if (!registeredResolver.equals(resolver)) {
            throw new IllegalArgumentException("The given resolver and the resolver that is registered with its token are not the same.");
        }
        if (manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(registeredResolver.getRequesterId()) && !manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(registeredResolver.getRequesterId()).isEmpty()) {
            throw new IllegalArgumentException("Cannot remove a resolver that is still in use. Reassign all registered requests before removing");
        }
        ResolverHandler.removeResolverInternal(manager, resolver);
    }

    public static Collection<IToken<?>> getRequestsAssignedToResolver(IStandardRequestManager manager, IRequestResolver<?> resolver) {
        if (manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolver.getRequesterId())) {
            return manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getRequesterId());
        }
        return Lists.newArrayList();
    }

    public static IRequestResolver<? extends IRequestable> getResolver(IStandardRequestManager manager, IToken<?> token) {
        if (!manager.getRequestResolverIdentitiesDataStore().getIdentities().containsKey(token)) {
            throw new IllegalArgumentException("The given token for a resolver is not known to this manager!");
        }
        LogHandler.log("Retrieving resolver for: " + token);
        return (IRequestResolver)manager.getRequestResolverIdentitiesDataStore().getIdentities().get(token);
    }

    public static void removeResolverInternal(IStandardRequestManager manager, IRequestResolver<?> resolver) {
        manager.getRequestResolverIdentitiesDataStore().getIdentities().remove(resolver.getRequesterId());
        Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(resolver.getRequestType());
        requestTypes.remove(TypeConstants.OBJECT);
        requestTypes.forEach(c -> {
            LogHandler.log("Removing resolver: " + resolver + " with request type: " + c);
            manager.getRequestableTypeRequestResolverAssignmentDataStore().getAssignments().get(c).remove(resolver.getRequesterId());
        });
    }

    public static void removeResolvers(IStandardRequestManager manager, IRequestResolver<?> ... resolvers) {
        ResolverHandler.removeResolvers(manager, Arrays.asList(resolvers));
    }

    public static void removeResolvers(IStandardRequestManager manager, Iterable<IRequestResolver<?>> resolvers) {
        resolvers.forEach(resolver -> ResolverHandler.removeResolver(manager, resolver));
    }

    public static void addRequestToResolver(IStandardRequestManager manager, IRequestResolver<?> resolver, IRequest<?> request) {
        if (!manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolver.getRequesterId())) {
            manager.getRequestResolverRequestAssignmentDataStore().getAssignments().put(resolver.getRequesterId(), new HashSet());
        }
        LogHandler.log("Adding request: " + request + " to resolver: " + resolver);
        manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getRequesterId()).add(request.getToken());
        request.setState(new WrappedStaticStateRequestManager(manager), RequestState.ASSIGNED);
    }

    public static void removeRequestFromResolver(IStandardRequestManager manager, IRequestResolver<?> resolver, IRequest<?> request) {
        if (!manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolver.getRequesterId())) {
            throw new IllegalArgumentException("The given resolver is unknown to this Manager");
        }
        if (!manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getRequesterId()).contains(request.getToken())) {
            throw new IllegalArgumentException("The given request is not registered to the given resolver.");
        }
        LogHandler.log("Removing request: " + request + " from resolver: " + resolver);
        manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getRequesterId()).remove(request.getToken());
        if (manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolver.getRequesterId()).isEmpty()) {
            manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(resolver.getRequesterId());
        }
    }

    public static IRequestResolver<? extends IRequestable> getResolverForRequest(IStandardRequestManager manager, IToken<?> requestToken) {
        RequestHandler.getRequest(manager, requestToken);
        IToken resolverToken = (IToken)manager.getRequestResolverRequestAssignmentDataStore().getAssignmentForValue(requestToken);
        if (resolverToken == null) {
            throw new IllegalArgumentException("The given request: " + requestToken + " is not resolved.");
        }
        return (IRequestResolver)manager.getRequestResolverIdentitiesDataStore().getIdentities().get((Object)resolverToken);
    }

    public static IRequestResolver<? extends IRequestable> getResolverForRequest(IStandardRequestManager manager, IRequest<?> request) {
        return ResolverHandler.getResolverForRequest(manager, request.getToken());
    }

    public static void onColonyUpdate(IStandardRequestManager manager, Predicate<IRequest> shouldTriggerReassign) {
        manager.getRequestResolverIdentitiesDataStore().getIdentities().values().forEach(resolver -> resolver.onColonyUpdate(manager, shouldTriggerReassign));
    }
}

