/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.ColonyProgressType;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFisherman;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.managers.interfaces.IProgressManager;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;

public class ProgressManager
implements IProgressManager {
    private final List<ColonyProgressType> notifiedProgress = new ArrayList<ColonyProgressType>();
    private final Colony colony;
    private boolean printProgress = true;

    public ProgressManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void progressBuildingPlacement(Block block) {
        if (block == ModBlocks.blockHutTownHall) {
            this.trigger(ColonyProgressType.COLONY_FOUNDED);
        } else if (block == ModBlocks.blockHutBuilder) {
            this.trigger(ColonyProgressType.BUILDER_PLACED);
        }
    }

    @Override
    public void progressCitizenSpawn(int total, int employed) {
        if (total == 1) {
            this.trigger(ColonyProgressType.FIRST_CITIZEN_SPAWNED);
        } else if (total == 4) {
            this.trigger(ColonyProgressType.FOUR_CITIZENS_SPAWNED);
        } else if (total == 5) {
            this.trigger(ColonyProgressType.FIVE_CITIZENS_SPAWNED);
        } else if (total == 6) {
            this.trigger(ColonyProgressType.SIX_CITIZENS_SPAWNED);
        } else if (total == 7) {
            this.trigger(ColonyProgressType.SEVEN_CITIZENS_SPAWNED);
        } else if (total == 8) {
            this.trigger(ColonyProgressType.EIGHT_CITIZENS_SPAWNED);
        } else if (total == 9) {
            this.trigger(ColonyProgressType.NINE_CITIZENS_SPAWNED);
        } else if (total >= 10 && employed >= 4) {
            this.trigger(ColonyProgressType.NOT_ENOUGH_JOBS);
        }
    }

    @Override
    public void progressWorkOrderPlacement(AbstractWorkOrder workOrder) {
        if (workOrder instanceof WorkOrderBuildBuilding && ((WorkOrderBuildBuilding)workOrder).getStructureName().contains("Builder")) {
            this.trigger(ColonyProgressType.BUILT_ENQUEUED);
        }
    }

    @Override
    public void progressBuildBuilding(AbstractBuilding building, int totalLevels, int totalHousing) {
        if (building instanceof BuildingBuilder) {
            this.trigger(ColonyProgressType.BUILDER_BUILT);
        } else if (building instanceof BuildingMiner || building instanceof BuildingLumberjack) {
            this.trigger(ColonyProgressType.RESOURCE_PROD_BUILT);
        } else if (building instanceof BuildingFisherman || building instanceof BuildingFarmer) {
            this.trigger(ColonyProgressType.FOOD_PROD_BUILT);
        } else if (totalHousing == 4 && (building instanceof BuildingTownHall || building instanceof BuildingHome)) {
            this.trigger(ColonyProgressType.ALL_CITIZENS_HOMED);
        } else if (building instanceof BuildingWareHouse) {
            this.trigger(ColonyProgressType.WAREHOUSE_BUILT);
        } else if (totalLevels == 20) {
            this.trigger(ColonyProgressType.TWENTY_BUILDING_LEVELS);
        }
    }

    @Override
    public void progressEmploy(int employed) {
        if (employed == 4) {
            this.trigger(ColonyProgressType.FOUR_CITIZEN_EMPLOYED);
        }
    }

    @Override
    public void progressEmploymentModeChange() {
        this.trigger(ColonyProgressType.MANUAL_EMPLOYMENT_ON);
    }

    @Override
    public void trigger(ColonyProgressType type) {
        if (!this.printProgress) {
            return;
        }
        if (!this.notifiedProgress.contains((Object)type)) {
            this.notifiedProgress.add(type);
            LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.progress." + type.name().toLowerCase(Locale.US), new Object[0]);
            this.colony.markDirty();
        }
    }

    @Override
    public void togglePrintProgress() {
        this.printProgress = !this.printProgress;
        this.colony.markDirty();
    }

    @Override
    public boolean isPrintingProgress() {
        return this.printProgress;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagCompound progressCompound = compound.func_74775_l("progressManager");
        NBTTagList progressTags = progressCompound.func_150295_c("progressList", 10);
        this.notifiedProgress.addAll(NBTUtils.streamCompound(progressTags).map(progressTypeCompound -> ColonyProgressType.values()[progressTypeCompound.func_74762_e("progressType")]).collect(Collectors.toList()));
        this.printProgress = progressCompound.func_74767_n("printProgrss");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagCompound progressCompound = new NBTTagCompound();
        NBTTagList progressTagList = this.notifiedProgress.stream().map(this::writeProgressTypeToNBT).collect(NBTUtils.toNBTTagList());
        progressCompound.func_74782_a("progressList", (NBTBase)progressTagList);
        progressCompound.func_74757_a("printProgrss", this.printProgress);
        compound.func_74782_a("progressManager", (NBTBase)progressCompound);
    }

    private NBTTagCompound writeProgressTypeToNBT(ColonyProgressType type) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("progressType", type.ordinal());
        return compound;
    }
}

