/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutLumberjack;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingLumberjack
extends AbstractFilterableListBuilding {
    private static final String TAG_REPLANT = "shouldReplant";
    private boolean replant = true;
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String LUMBERJACK = "Lumberjack";

    public BuildingLumberjack(Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        if (this.getMainCitizen() != null && this.getMainCitizen().getInventory() != null) {
            int invSIze = this.getMainCitizen().getInventory().func_70302_i_();
            int keptStacks = 0;
            for (int i = 0; i < invSIze; ++i) {
                ItemStack stack = this.getMainCitizen().getInventory().func_70301_a(i);
                if (ItemStackUtils.isEmpty(stack).booleanValue() || !ItemStackUtils.isStackSapling(stack)) continue;
                boolean isAlreadyInList = false;
                for (Map.Entry entry : toKeep.entrySet()) {
                    if (!((Predicate)entry.getKey()).test(stack)) continue;
                    isAlreadyInList = true;
                }
                if (isAlreadyInList) continue;
                toKeep.put(arg_0 -> ((ItemStack)stack).func_77969_a(arg_0), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
                if (++keptStacks < this.getMaxBuildingLevel() * 2) continue;
                return toKeep;
            }
        }
        return toKeep;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingLumberjack);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeLumberjackMax);
        }
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobLumberjack(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.replant = compound.func_74764_b(TAG_REPLANT) ? compound.func_74767_n(TAG_REPLANT) : true;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74757_a(TAG_REPLANT, this.replant);
    }

    @Override
    @NotNull
    public String getJobName() {
        return LUMBERJACK;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.replant);
    }

    public boolean shouldReplant() {
        return this.replant;
    }

    public void setShouldReplant(boolean shouldReplant) {
        this.replant = shouldReplant;
        this.markDirty();
    }

    public static class View
    extends AbstractFilterableListsView {
        public boolean shouldReplant = true;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.shouldReplant = buf.readBoolean();
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.CHARISMA;
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutLumberjack(this);
        }
    }
}

