/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.entity.EntityCitizen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCitizenAssignable
extends AbstractSchematicProvider {
    @NotNull
    protected final Colony colony;
    private final List<CitizenData> assignedCitizen = new ArrayList<CitizenData>();

    public AbstractCitizenAssignable(BlockPos pos, Colony colony) {
        super(pos);
        this.colony = colony;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.assignedCitizen.clear();
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
    }

    @NotNull
    public Colony getColony() {
        return this.colony;
    }

    public void onDestroyed() {
        this.assignedCitizen.clear();
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    public CitizenData getMainCitizen() {
        if (this.assignedCitizen.isEmpty()) {
            return null;
        }
        return this.assignedCitizen.get(0);
    }

    public List<CitizenData> getAssignedCitizen() {
        return new ArrayList<CitizenData>(this.assignedCitizen);
    }

    public void removeCitizen(CitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            this.assignedCitizen.remove(citizen);
            this.markDirty();
        }
    }

    public boolean isCitizenAssigned(CitizenData citizen) {
        return this.assignedCitizen.contains(citizen);
    }

    public Optional<EntityCitizen> getMainCitizenEntity() {
        if (this.assignedCitizen.isEmpty()) {
            return Optional.empty();
        }
        return this.assignedCitizen.get(0).getCitizenEntity();
    }

    public final boolean hasAssignedCitizen() {
        return !this.assignedCitizen.isEmpty();
    }

    @Nullable
    public List<Optional<EntityCitizen>> getAssignedEntities() {
        return this.assignedCitizen.stream().filter(Objects::nonNull).map(CitizenData::getCitizenEntity).collect(Collectors.toList());
    }

    public boolean assignCitizen(CitizenData citizen) {
        if (this.assignedCitizen.contains(citizen) || this.isFull()) {
            return false;
        }
        if (citizen != null) {
            this.assignedCitizen.add(citizen);
        }
        this.markDirty();
        return true;
    }

    public boolean hasAssignedCitizen(CitizenData citizen) {
        return this.assignedCitizen.contains(citizen);
    }

    public boolean isFull() {
        return this.assignedCitizen.size() >= this.getMaxInhabitants();
    }

    public int getMaxInhabitants() {
        return 1;
    }
}

