/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;

public class HappinessData {
    private static final String TAG_TASKS = "happiness";
    private static final String TAG_GUARDS = "guards";
    private static final String TAG_HOUSING = "housing";
    private static final String TAG_SATURATION = "saturation";
    private static final String TAG_HOUSING_MODIFIER = "housingRatioModifier";
    private static final String TAG_DEATH_MODIFIER = "deathModifier";
    private static final String TAG_TOTAL_DEATH_MODIFIER = "totalDeathModifier";
    private static final String TAG_DEATH_NUMOFDAYS = "numOfDays";
    private static final String TAG_DEATH_NUMOFDAYS_LAST = "numOfDaysLast";
    private static final String TAG_DEATH_MODIFIER_VALUE = "modifier";
    private static final String TAG_DEATH_ADJUSTMENT_MODIFIER = "adjustmentModifier";
    public static final int MAX_DAYS_DEATH_MODIFIER_LAST = 20;
    public static final int MAX_DAYS_DEATH_MODIFIER_LAST_GUARDS = 5;
    public static final int MAX_HAPPINESS = 10;
    public static final int MIN_HAPPINESS = 1;
    public static final int MAX_DEATH_MODIFIER = 6;
    public static final int INCREASE = 1;
    public static final int STABLE = 0;
    public static final int DECREASE = -1;
    private int guards;
    private int housing;
    private int saturation;
    private double housingRatioModifier;
    private List<DeathModifierData> deathModifier = new ArrayList<DeathModifierData>();

    public int getGuards() {
        return this.guards;
    }

    public void setGuards(int guards) {
        this.guards = guards;
    }

    public int getHousing() {
        return this.housing;
    }

    public void setHousing(int housing) {
        this.housing = housing;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public void setSaturation(int saturation) {
        this.saturation = saturation;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.guards = byteBuf.readInt();
        this.housing = byteBuf.readInt();
        this.saturation = byteBuf.readInt();
        this.housingRatioModifier = byteBuf.readDouble();
        int numDeaths = byteBuf.readInt();
        for (int index = 0; index < numDeaths; ++index) {
            int numDays = byteBuf.readInt();
            double modifier = byteBuf.readDouble();
            int numDayslast = byteBuf.readInt();
            double adjustment = byteBuf.readDouble();
            DeathModifierData data = new DeathModifierData(numDays, modifier, numDayslast);
            data.setAdjustment(adjustment);
            this.deathModifier.add(data);
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.guards);
        byteBuf.writeInt(this.housing);
        byteBuf.writeInt(this.saturation);
        byteBuf.writeDouble(this.housingRatioModifier);
        byteBuf.writeInt(this.deathModifier.size());
        for (int index = 0; index < this.deathModifier.size(); ++index) {
            byteBuf.writeInt(this.deathModifier.get(index).getDaysSinceEvent());
            byteBuf.writeDouble(this.deathModifier.get(index).getModifier());
            byteBuf.writeInt(this.deathModifier.get(index).getNumDaysLast());
            byteBuf.writeDouble(this.deathModifier.get(index).getAdjustmentModifier());
        }
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagList happinessTagList = compound.func_150295_c(TAG_TASKS, 10);
        NBTTagCompound tagCompound = happinessTagList.func_150305_b(0);
        this.guards = tagCompound.func_74762_e(TAG_GUARDS);
        this.housing = tagCompound.func_74762_e(TAG_HOUSING);
        this.saturation = tagCompound.func_74762_e(TAG_SATURATION);
        this.housingRatioModifier = tagCompound.func_74769_h(TAG_HOUSING_MODIFIER);
        int numDeaths = tagCompound.func_74762_e(TAG_TOTAL_DEATH_MODIFIER);
        NBTTagList deathTagList = tagCompound.func_150295_c(TAG_DEATH_MODIFIER, 10);
        for (int i = 0; i < numDeaths; ++i) {
            NBTTagCompound deathCompound = deathTagList.func_150305_b(i);
            int numDays = deathCompound.func_74762_e(TAG_DEATH_NUMOFDAYS);
            double value = deathCompound.func_74769_h(TAG_DEATH_MODIFIER_VALUE);
            int numDaysLast = deathCompound.func_74762_e(TAG_DEATH_NUMOFDAYS_LAST);
            double adjustment = deathCompound.func_74769_h(TAG_DEATH_ADJUSTMENT_MODIFIER);
            DeathModifierData data = new DeathModifierData(numDays, value, numDaysLast);
            data.setAdjustment(adjustment);
            this.deathModifier.add(data);
        }
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList tasksTagList = new NBTTagList();
        NBTTagCompound taskCompound = new NBTTagCompound();
        taskCompound.func_74768_a(TAG_GUARDS, this.guards);
        taskCompound.func_74768_a(TAG_HOUSING, this.housing);
        taskCompound.func_74768_a(TAG_SATURATION, this.saturation);
        taskCompound.func_74780_a(TAG_HOUSING_MODIFIER, this.housingRatioModifier);
        taskCompound.func_74768_a(TAG_TOTAL_DEATH_MODIFIER, this.deathModifier.size());
        NBTTagList deathTagList = new NBTTagList();
        for (int i = 0; i < this.deathModifier.size(); ++i) {
            NBTTagCompound deathCompound = new NBTTagCompound();
            DeathModifierData data = this.deathModifier.get(i);
            deathCompound.func_74768_a(TAG_DEATH_NUMOFDAYS, data.getDaysSinceEvent());
            deathCompound.func_74780_a(TAG_DEATH_MODIFIER_VALUE, data.getModifier());
            deathCompound.func_74768_a(TAG_DEATH_NUMOFDAYS_LAST, data.getNumDaysLast());
            deathCompound.func_74780_a(TAG_DEATH_ADJUSTMENT_MODIFIER, data.getAdjustmentModifier());
            deathTagList.func_74742_a((NBTBase)deathCompound);
        }
        taskCompound.func_74782_a(TAG_DEATH_MODIFIER, (NBTBase)deathTagList);
        tasksTagList.func_74742_a((NBTBase)taskCompound);
        compound.func_74782_a(TAG_TASKS, (NBTBase)tasksTagList);
    }

    public void setValues(HappinessData data) {
        this.guards = data.guards;
        this.saturation = data.saturation;
        this.housing = data.housing;
        this.deathModifier = data.deathModifier;
        this.housingRatioModifier = data.housingRatioModifier;
    }

    public void setDeathModifier(double modifier, boolean isGuard) {
        int numDays = 20;
        if (isGuard) {
            numDays = 5;
        }
        DeathModifierData data = new DeathModifierData(0, modifier, numDays);
        this.deathModifier.add(data);
    }

    public double getDeathModifier() {
        double value = 0.0;
        for (int index = 0; index < this.deathModifier.size(); ++index) {
            value += this.deathModifier.get(index).getModifier();
        }
        if (value > 6.0) {
            value = 6.0;
        }
        return value;
    }

    public void setHousingModifier(double modifier) {
        this.housingRatioModifier = modifier;
    }

    public double getHousingModifier() {
        return this.housingRatioModifier;
    }

    public void processDeathModifiers() {
        for (int index = 0; index < this.deathModifier.size(); ++index) {
            DeathModifierData data = this.deathModifier.get(index);
            data.increaseDay();
            if (data.getDaysSinceEvent() <= data.getNumDaysLast()) continue;
            this.deathModifier.remove(index);
            --index;
        }
    }

    public double getTotalHappinessModifier() {
        return this.housingRatioModifier + this.getDeathModifier();
    }

    public class DeathModifierData {
        private int daysSinceEvent;
        private double modifier;
        private final int numDaysLast;
        private double adjustment;

        public DeathModifierData(int daysSinceEvent, double modifier, int numDaysLast) {
            this.daysSinceEvent = daysSinceEvent;
            this.modifier = modifier;
            this.numDaysLast = numDaysLast;
            this.adjustment = modifier / (double)numDaysLast;
        }

        public int getDaysSinceEvent() {
            return this.daysSinceEvent;
        }

        public double getAdjustmentModifier() {
            return this.adjustment;
        }

        public void setAdjustment(double adjustment) {
            this.adjustment = adjustment;
        }

        public void setModifier(double modifier) {
            this.modifier = modifier;
        }

        public double getModifier() {
            return this.modifier;
        }

        public int getNumDaysLast() {
            return this.numDaysLast;
        }

        public void increaseDay() {
            ++this.daysSinceEvent;
            this.modifier -= this.adjustment;
        }
    }
}

