/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.compatibility.CompatibilityManager;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyManagerConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import com.minecolonies.coremod.colony.ColonyManagerWorldAccess;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.HappinessData;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRecipeManager;
import com.minecolonies.coremod.util.BackUpHelper;
import com.minecolonies.coremod.util.ChunkDataHelper;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager {
    @NotNull
    private static final Map<Integer, ColonyList<ColonyView>> colonyViews = new HashMap<Integer, ColonyList<ColonyView>>();
    private static final IRecipeManager recipeManager = new StandardRecipeManager();
    private static final ICompatibilityManager compatibilityManager = new CompatibilityManager();
    private static volatile UUID serverUUID = null;
    private static boolean schematicDownloaded = false;
    private static boolean loaded = false;

    private ColonyManager() {
    }

    public static void createColony(@NotNull World w, BlockPos pos, @NotNull EntityPlayer player, @NotNull String style) {
        IColonyManagerCapability cap = (IColonyManagerCapability)w.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return;
        }
        Colony colony = cap.createColony(w, pos);
        colony.setStyle(style);
        String colonyName = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.defaultName", player.getDisplayNameString());
        colony.setName(colonyName);
        colony.getPermissions().setPlayerRank(player.func_146103_bH().getId(), Rank.OWNER, w);
        colony.getStatsManager().triggerAchievement(ModAchievements.achievementGetSupply);
        colony.getStatsManager().triggerAchievement(ModAchievements.achievementTownhall);
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.func_70005_c_()));
        if (colony.getWorld() == null) {
            Log.getLogger().error("Unable to claim chunks because of the missing world in the colony, please report this to the mod authors!");
            return;
        }
        if (Configurations.gameplay.enableDynamicColonySizes) {
            ChunkDataHelper.claimColonyChunks(colony.getWorld(), true, colony.getID(), colony.getCenter(), colony.getDimension(), 2);
        } else {
            ChunkDataHelper.claimColonyChunks(colony.getWorld(), true, colony.getID(), colony.getCenter(), colony.getDimension());
        }
    }

    public static void deleteColonyByWorld(int id, boolean canDestroy, World world) {
        ColonyManager.deleteColony(ColonyManager.getColonyByWorld(id, world), canDestroy);
    }

    public static void deleteColonyByDimension(int id, boolean canDestroy, int dimension) {
        ColonyManager.deleteColony(ColonyManager.getColonyByDimension(id, dimension), canDestroy);
    }

    private static void deleteColony(@Nullable Colony colony, boolean canDestroy) {
        if (colony == null) {
            Log.getLogger().warn("Deleting Colony errored, colony null");
            return;
        }
        int id = colony.getID();
        World world = colony.getWorld();
        try {
            if (!Configurations.gameplay.enableDynamicColonySizes) {
                ChunkDataHelper.claimColonyChunks(world, false, id, colony.getCenter(), colony.getDimension());
            }
            Log.getLogger().info("Removing citizens for " + id);
            for (CitizenData citizenData : new ArrayList<CitizenData>(colony.getCitizenManager().getCitizens())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                citizenData.getCitizenEntity().ifPresent(entityCitizen -> entityCitizen.func_70645_a(ColonyManagerConstants.CONSOLE_DAMAGE_SOURCE));
            }
            Log.getLogger().info("Removing buildings for " + id);
            for (AbstractBuilding building : new ArrayList<AbstractBuilding>(colony.getBuildingManager().getBuildings().values())) {
                BlockPos location = building.getLocation();
                Log.getLogger().info("Delete Building at " + location);
                if (canDestroy) {
                    building.deconstruct();
                }
                building.destroy();
                if (!(world.func_180495_p(location).func_177230_c() instanceof AbstractBlockHut)) continue;
                Log.getLogger().info("Found Block, deleting " + world.func_180495_p(location).func_177230_c());
                world.func_175698_g(location);
            }
            MinecraftForge.EVENT_BUS.unregister((Object)colony.getEventHandler());
            Log.getLogger().info("Deleting colony: " + colony.getID());
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
            if (cap == null) {
                Log.getLogger().warn("Missing world capability with colony manager!");
                return;
            }
            cap.deleteColony(id);
            Log.getLogger().info("Done with " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
    }

    @Nullable
    public static Colony getColonyByWorld(int id, World world) {
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Nullable
    public static Colony getColonyByDimension(int id, int dimension) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    public static AbstractBuilding getBuilding(@NotNull World w, @NotNull BlockPos pos) {
        AbstractBuilding building;
        Colony colony = ColonyManager.getColonyByPosFromWorld(w, pos);
        if (colony != null && (building = colony.getBuildingManager().getBuilding(pos)) != null) {
            return building;
        }
        for (Colony otherColony : ColonyManager.getColonies(w)) {
            AbstractBuilding building2 = otherColony.getBuildingManager().getBuilding(pos);
            if (building2 == null) continue;
            return building2;
        }
        return null;
    }

    public static Colony getColonyByPosFromWorld(@NotNull World w, @NotNull BlockPos pos) {
        Chunk centralChunk = w.func_175726_f(pos);
        int id = ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony();
        if (id == 0) {
            return null;
        }
        return ColonyManager.getColonyByWorld(id, w);
    }

    public static Colony getColonyByPosFromDim(int dim, @NotNull BlockPos pos) {
        WorldServer w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
        return ColonyManager.getColonyByPosFromWorld((World)w, pos);
    }

    public static boolean isTooCloseToColony(@NotNull World w, @NotNull BlockPos pos) {
        if (Configurations.gameplay.enableDynamicColonySizes) {
            return !ChunkDataHelper.canClaimChunksInRange(w, pos, Configurations.gameplay.minTownHallPadding);
        }
        IChunkmanagerCapability worldCapability = (IChunkmanagerCapability)w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (worldCapability == null) {
            return true;
        }
        Chunk centralChunk = w.func_175726_f(pos);
        IColonyTagCapability colonyCap = (IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (colonyCap == null) {
            return true;
        }
        ChunkLoadStorage storage = worldCapability.getChunkStorage(centralChunk.field_76635_g, centralChunk.field_76647_h);
        if (storage != null) {
            storage.applyToCap(colonyCap);
        }
        return !colonyCap.getAllCloseColonies().isEmpty();
    }

    @NotNull
    public static List<Colony> getColonies(@NotNull World w) {
        IColonyManagerCapability cap = (IColonyManagerCapability)w.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return Collections.emptyList();
        }
        return cap.getColonies();
    }

    @NotNull
    public static List<Colony> getAllColonies() {
        ArrayList<Colony> allColonies = new ArrayList<Colony>();
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
            if (cap == null) continue;
            allColonies.addAll(cap.getColonies());
        }
        return allColonies;
    }

    @NotNull
    public static List<Colony> getColoniesAbandonedSince(int abandonedSince) {
        ArrayList<Colony> sortedList = new ArrayList<Colony>();
        for (Colony colony : ColonyManager.getAllColonies()) {
            if (colony.getLastContactInHours() < abandonedSince) continue;
            sortedList.add(colony);
        }
        return sortedList;
    }

    public static AbstractBuildingView getBuildingView(int dimension, BlockPos pos) {
        if (colonyViews.containsKey(dimension)) {
            for (ColonyView colony : colonyViews.get(dimension)) {
                AbstractBuildingView building = colony.getBuilding(pos);
                if (building == null) continue;
                return building;
            }
        }
        return null;
    }

    @Nullable
    public static IColony getIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getColonyView(w, pos) : ColonyManager.getColonyByPosFromWorld(w, pos);
    }

    private static ColonyView getColonyView(@NotNull World w, @NotNull BlockPos pos) {
        Chunk centralChunk = w.func_175726_f(pos);
        int id = ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony();
        if (id == 0) {
            return null;
        }
        return ColonyManager.getColonyView(id, w.field_73011_w.getDimension());
    }

    @Nullable
    public static IColony getClosestIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getClosestColonyView(w, pos) : ColonyManager.getClosestColony(w, pos);
    }

    @Nullable
    public static ColonyView getClosestColonyView(@Nullable World w, @Nullable BlockPos pos) {
        if (w == null || pos == null) {
            return null;
        }
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap.getOwningColony() != 0) {
            return ColonyManager.getColonyView(cap.getOwningColony(), w.field_73011_w.getDimension());
        }
        if (!cap.getAllCloseColonies().isEmpty()) {
            ColonyView closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getAllCloseColonies()) {
                long dist;
                ColonyView c = ColonyManager.getColonyView(cId, w.field_73011_w.getDimension());
                if (c == null || c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        ColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        if (colonyViews.containsKey(w.field_73011_w.getDimension())) {
            for (ColonyView c : colonyViews.get(w.field_73011_w.getDimension())) {
                long dist;
                if (c.getDimension() != w.field_73011_w.getDimension() || c.getCenter() == null || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
        }
        return closestColony;
    }

    public static Colony getClosestColony(@NotNull World w, @NotNull BlockPos pos) {
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap.getOwningColony() != 0) {
            return ColonyManager.getColonyByWorld(cap.getOwningColony(), w);
        }
        if (!cap.getAllCloseColonies().isEmpty()) {
            Colony closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getAllCloseColonies()) {
                long dist;
                Colony c = ColonyManager.getColonyByWorld(cId, w);
                if (c == null || c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        Colony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (Colony c : ColonyManager.getColonies(w)) {
            long dist;
            if (c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, @NotNull EntityPlayer owner) {
        return ColonyManager.getIColonyByOwner(w, w.field_72995_K ? owner.func_110124_au() : owner.func_146103_bH().getId());
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, UUID owner) {
        return w.field_72995_K ? ColonyManager.getColonyViewByOwner(owner, w.field_73011_w.getDimension()) : ColonyManager.getColonyByOwner(owner);
    }

    private static IColony getColonyViewByOwner(UUID owner, int dimension) {
        if (colonyViews.containsKey(dimension)) {
            for (ColonyView c : colonyViews.get(dimension)) {
                Player p = c.getPlayers().get(owner);
                if (p == null || !p.getRank().equals((Object)Rank.OWNER)) continue;
                return c;
            }
        }
        return null;
    }

    @Nullable
    private static IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        return ColonyManager.getAllColonies().stream().filter(c -> owner.equals(c.getPermissions().getOwner())).findFirst().orElse(null);
    }

    public static int getMinimumDistanceBetweenTownHalls() {
        return 2 * Configurations.gameplay.workingRangeTownHallChunks * 16 + Configurations.gameplay.townHallPaddingChunk * 16;
    }

    public static void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Colony c : ColonyManager.getAllColonies()) {
                c.onServerTick(event);
            }
        }
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound) {
        if (serverUUID != null) {
            compound.func_186854_a("uuid", serverUUID);
        }
        NBTTagCompound compCompound = new NBTTagCompound();
        compatibilityManager.writeToNBT(compCompound);
        compound.func_74782_a("compatabilityManager", (NBTBase)compCompound);
        compound.func_74757_a("dist", true);
        NBTTagCompound recipeCompound = new NBTTagCompound();
        recipeManager.writeToNBT(recipeCompound);
        compound.func_74782_a("recipeManager", (NBTBase)recipeCompound);
        compound.func_74757_a("allchunk", true);
        compound.func_74757_a("amountOfColonies", true);
        compound.func_74757_a("colonycap", true);
    }

    public static void readFromNBT(@NotNull NBTTagCompound compound, @NotNull World world) {
        if (!compound.func_74764_b("dist")) {
            Configurations.gameplay.workingRangeTownHallChunks = (int)(Math.cos(0.7853981633974483) * (double)Configurations.gameplay.workingRangeTownHall / 16.0);
        }
        if (!compound.func_74764_b("colonycap")) {
            if (!compound.func_74764_b("amountOfColonies")) {
                NBTTagList colonyTags = compound.func_150295_c("colonies", 10);
                for (int i = 0; i < colonyTags.func_74745_c(); ++i) {
                    NBTTagCompound colonyCompound = colonyTags.func_150305_b(i);
                    WorldServer colonyWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(colonyCompound.func_74762_e("dimension"));
                    IColonyManagerCapability cap = (IColonyManagerCapability)colonyWorld.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
                    Colony colony = Colony.loadColony(colonyTags.func_150305_b(i), (World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(colonyCompound.func_74762_e("dimension")));
                    cap.addColony(colony);
                }
                IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
                cap.setMissingChunksToLoad(compound.func_74762_e("missingChunks"));
                Log.getLogger().info(String.format("Loaded %d colonies", cap.getColonies().size()));
            } else {
                int size = compound.func_74762_e("amountOfColonies");
                File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
                for (int colonyId = 0; colonyId <= size; ++colonyId) {
                    NBTTagCompound colonyData = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format("colony%d.dat", colonyId)));
                    if (colonyData == null) continue;
                    WorldServer colonyWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(colonyData.func_74762_e("dimension"));
                    IColonyManagerCapability cap = (IColonyManagerCapability)colonyWorld.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
                    Colony colony = Colony.loadColony(colonyData, (World)colonyWorld);
                    colony.getCitizenManager().checkCitizensForHappiness();
                    cap.addColony(colony);
                }
            }
        }
        if (compound.func_186855_b("uuid")) {
            serverUUID = compound.func_186857_a("uuid");
        }
        if (compound.func_74764_b("compatabilityManager")) {
            compatibilityManager.readFromNBT(compound.func_74775_l("compatabilityManager"));
        }
        NBTTagCompound recipeCompound = compound.func_74775_l("recipeManager");
        recipeManager.readFromNBT(recipeCompound);
        if (!compound.func_74764_b("allchunk")) {
            ChunkDataHelper.loadChunkStorageToWorldCapability(world);
        }
    }

    public static void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e == null && !colonyViews.isEmpty()) {
            colonyViews.clear();
        }
        if (!compatibilityManager.isDiscoveredAlready()) {
            compatibilityManager.discover();
        }
    }

    public static void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ColonyManager.getColonies(event.world).forEach(c -> c.onWorldTick(event));
        }
        if (!compatibilityManager.isDiscoveredAlready()) {
            compatibilityManager.discover();
        }
    }

    public static void onWorldLoad(@NotNull World world) {
        if (!world.field_72995_K) {
            if (!loaded) {
                File file = BackUpHelper.getSaveLocation();
                NBTTagCompound data = BackUpHelper.loadNBTFromPath(file);
                if (data != null) {
                    ColonyManager.readFromNBT(data, world);
                }
                if (serverUUID == null) {
                    serverUUID = UUID.randomUUID();
                    Log.getLogger().info(String.format("New Server UUID %s", serverUUID));
                } else {
                    Log.getLogger().info(String.format("Server UUID %s", serverUUID));
                }
                loaded = true;
            }
            for (Colony c : ColonyManager.getColonies(world)) {
                c.onWorldLoad(world);
            }
            world.func_72954_a((IWorldEventListener)new ColonyManagerWorldAccess());
        }
    }

    public static UUID getServerUUID() {
        return serverUUID;
    }

    public static void setServerUUID(UUID uuid) {
        serverUUID = uuid;
    }

    public static void onWorldUnload(@NotNull World world) {
        if (!world.field_72995_K && !(world instanceof WorldServerMulti)) {
            for (Colony c : ColonyManager.getColonies(world)) {
                c.onWorldUnload(world);
            }
            if (loaded) {
                BackUpHelper.backupColonyData();
                loaded = false;
            }
        }
    }

    public static void handleColonyViewMessage(int colonyId, @NotNull ByteBuf colonyData, @NotNull World world, boolean isNewSubscription, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyId, dim);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            if (colonyViews.containsKey(dim)) {
                colonyViews.get(dim).add(view);
            } else {
                ColonyList<ColonyView> list = new ColonyList<ColonyView>();
                list.add(view);
                colonyViews.put(dim, list);
            }
        }
        view.handleColonyViewMessage(colonyData, world, isNewSubscription);
    }

    public static ColonyView getColonyView(int id, int dimension) {
        if (colonyViews.containsKey(dimension)) {
            return colonyViews.get(dimension).get(id);
        }
        return null;
    }

    public static void handlePermissionsViewMessage(int colonyID, @NotNull ByteBuf data, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyID, dim);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID));
        } else {
            view.handlePermissionsViewMessage(data);
        }
    }

    public static void handleColonyViewCitizensMessage(int colonyId, int citizenId, ByteBuf buf, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    public static void handleColonyViewWorkOrderMessage(int colonyId, ByteBuf buf, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewWorkOrderMessage(buf);
    }

    public static void handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
    }

    public static void handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull ByteBuf buf, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyBuildingViewMessage(buildingId, buf);
        } else {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId));
        }
    }

    public static void handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
    }

    public static void handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
    }

    public static void handleHappinessDataMessage(int colonyId, HappinessData data, int dim) {
        ColonyView view = ColonyManager.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleHappinessDataMessage(data);
        }
    }

    public static boolean isSchematicDownloaded() {
        return schematicDownloaded;
    }

    public static void setSchematicDownloaded(boolean downloaded) {
        schematicDownloaded = downloaded;
    }

    public static boolean isCoordinateInAnyColony(@NotNull World world, BlockPos pos) {
        Chunk centralChunk = world.func_175726_f(pos);
        return ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony() != 0;
    }

    public static ICompatibilityManager getCompatibilityManager() {
        return compatibilityManager;
    }

    public static IRecipeManager getRecipeManager() {
        return recipeManager;
    }

    public static int getTopColonyId() {
        int top = 0;
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            int tempTop;
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
            if (cap == null || (tempTop = cap.getTopID()) <= top) continue;
            top = tempTop;
        }
        return top;
    }
}

