/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractHutFilterableLists;
import com.minecolonies.coremod.client.gui.ViewFilterableList;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.network.messages.LumberjackReplantSaplingToggleMessage;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutLumberjack
extends AbstractHutFilterableLists {
    private static final String BUTTON_TOGGLE_REPLANT = "saplingReplant";
    private static final String PAGE_ITEMS_VIEW = "saplings";
    private static final String RESOURCE_STRING = ":gui/windowhutlumberjack.xml";
    private final BuildingLumberjack.View ownBuilding;

    public WindowHutLumberjack(BuildingLumberjack.View building) {
        super(building, "minecolonies:gui/windowhutlumberjack.xml", new Tuple[0]);
        ViewFilterableList window = new ViewFilterableList(this.findPaneOfTypeByID(PAGE_ITEMS_VIEW, View.class), this, building, LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.saplingList", new Object[0]), PAGE_ITEMS_VIEW, true);
        this.views.put(PAGE_ITEMS_VIEW, window);
        this.ownBuilding = building;
        this.setupReplantButton(this.findPaneOfTypeByID(BUTTON_TOGGLE_REPLANT, Button.class));
        this.registerButton(BUTTON_TOGGLE_REPLANT, this::switchReplant);
    }

    @Override
    public List<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate, String id) {
        return ColonyManager.getCompatibilityManager().getCopyOfSaplings().stream().filter(storage -> filterPredicate.test(storage.getItemStack())).collect(Collectors.toList());
    }

    private void setupReplantButton(Button button) {
        if (this.ownBuilding.shouldReplant) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleReplantSaplingsOn", new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleReplantSaplingsOff", new Object[0]));
        }
    }

    private void switchReplant(Button replant) {
        this.ownBuilding.shouldReplant = !this.ownBuilding.shouldReplant;
        this.setupReplantButton(replant);
        MineColonies.getNetwork().sendToServer((IMessage)new LumberjackReplantSaplingToggleMessage(this.ownBuilding, this.ownBuilding.shouldReplant));
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.job.Lumberjack";
    }
}

