/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.network.messages.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.TransferItemsRequestMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowHutBuilder
extends AbstractWindowWorkerBuilding<BuildingBuilder.View> {
    public static final int RED = Color.getByName("red", 0);
    public static final int DARKGREEN = Color.getByName("darkgreen", 0);
    public static final int BLACK = Color.getByName("black", 0);
    private final BuildingBuilder.View builder;
    @NotNull
    private final List<BuildingBuilderResource> resources = new ArrayList<BuildingBuilderResource>();

    public WindowHutBuilder(BuildingBuilder.View building) {
        super(building, "minecolonies:gui/windowhutbuilder.xml");
        this.builder = building;
        this.pullResourcesFromHut();
        this.registerButton("resourceAdd", this::transferItems);
    }

    private void pullResourcesFromHut() {
        AbstractBuildingView newView = this.builder.getColony().getBuilding(this.builder.getID());
        if (newView instanceof BuildingBuilder.View) {
            BuildingBuilder.View updatedView = (BuildingBuilder.View)newView;
            InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
            boolean isCreative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
            this.resources.clear();
            this.resources.addAll(updatedView.getResources().values());
            for (BuildingBuilderResource resource : this.resources) {
                int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77969_a(resource.getItemStack()));
                resource.setPlayerAmount(amountToSet);
            }
            this.resources.sort(new BuildingBuilderResource.ResourceComparator());
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.pullResourcesFromHut();
        ScrollingList resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutBuilder.this.resources.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                WindowHutBuilder.this.updateResourcePane(index, rowPane);
            }
        });
        MineColonies.getNetwork().sendToServer((IMessage)new MarkBuildingDirtyMessage(this.building));
        this.findPaneOfTypeByID("constructionName", Label.class).setLabelText(((BuildingBuilder.View)this.building).getConstructionName());
        this.findPaneOfTypeByID("constructionPos", Label.class).setLabelText(((BuildingBuilder.View)this.building).getConstructionPos());
        this.findPaneOfTypeByID("progress", Label.class).setLabelText(((BuildingBuilder.View)this.building).getProgress());
    }

    private void updateResourcePane(int index, @NotNull Pane rowPane) {
        BuildingBuilderResource resource = this.resources.get(index);
        Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
        Label resourceMissingLabel = rowPane.findPaneOfTypeByID("resourceMissing", Label.class);
        Label neededLabel = rowPane.findPaneOfTypeByID("resourceAvailableNeeded", Label.class);
        Button addButton = rowPane.findPaneOfTypeByID("resourceAdd", Button.class);
        switch (resource.getAvailabilityStatus()) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColor(RED, RED);
                resourceMissingLabel.setColor(RED, RED);
                neededLabel.setColor(RED, RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColor(RED, RED);
                resourceMissingLabel.setColor(RED, RED);
                neededLabel.setColor(RED, RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColor(DARKGREEN, DARKGREEN);
                resourceMissingLabel.setColor(DARKGREEN, DARKGREEN);
                neededLabel.setColor(DARKGREEN, DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColor(BLACK, BLACK);
                resourceMissingLabel.setColor(BLACK, BLACK);
                neededLabel.setColor(BLACK, BLACK);
            }
        }
        int buttonX = rowPane.getWidth() - addButton.getWidth() - (rowPane.getHeight() - addButton.getHeight()) / 2;
        int buttonY = rowPane.getHeight() - addButton.getHeight() - 2;
        addButton.setPosition(buttonX, buttonY);
        resourceLabel.setLabelText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setLabelText(Integer.toString(missing));
        } else {
            resourceMissingLabel.setLabelText("");
        }
        neededLabel.setLabelText(Integer.toString(resource.getAvailable()) + " / " + Integer.toString(resource.getAmount()));
        rowPane.findPaneOfTypeByID("resourceId", Label.class).setLabelText(Integer.toString(index));
        rowPane.findPaneOfTypeByID("resourceQuantity", Label.class).setLabelText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        ItemStack stack = new ItemStack(resource.getItem(), 1, resource.getDamageValue());
        stack.func_77982_d(resource.getItemStack().func_77978_p());
        rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(stack);
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.buildersHut";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        String currentPage = this.findPaneOfTypeByID("pages", SwitchView.class).getCurrentView().getID();
        if (currentPage.equals("resourceActions")) {
            this.pullResourcesFromHut();
            this.window.findPaneOfTypeByID("resources", ScrollingList.class).refreshElementPanes();
        }
    }

    private void transferItems(@NotNull Button button) {
        View pane = button.getParent();
        Label idLabel = pane.findPaneOfTypeByID("resourceId", Label.class);
        int index = Integer.parseInt(idLabel.getLabelText());
        BuildingBuilderResource res = this.resources.get(index);
        if (res == null) {
            Log.getLogger().warn("WindowHutBuilder.transferItems: Error - Could not find the resource.");
        } else {
            ItemStack itemStack = new ItemStack(res.getItem(), 1, res.getDamageValue());
            itemStack.func_77982_d(res.getItemStack().func_77978_p());
            Label quantityLabel = pane.findPaneOfTypeByID("resourceQuantity", Label.class);
            int quantity = Integer.parseInt(quantityLabel.getLabelText());
            MineColonies.getNetwork().sendToServer((IMessage)new TransferItemsRequestMessage(this.building, itemStack, quantity, true));
        }
    }
}

