/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blockout.views;

import com.minecolonies.blockout.Alignment;
import com.minecolonies.blockout.Loader;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.PaneParams;
import com.minecolonies.blockout.views.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class View
extends Pane {
    @NotNull
    protected List<Pane> children = new ArrayList<Pane>();
    protected int padding = 0;

    public View() {
    }

    public View(PaneParams params) {
        super(params);
        this.padding = params.getIntegerAttribute("padding", this.padding);
    }

    @NotNull
    public List<Pane> getChildren() {
        return this.children;
    }

    @Override
    public void parseChildren(PaneParams params) {
        List<PaneParams> childNodes = params.getChildren();
        if (childNodes == null) {
            return;
        }
        for (PaneParams node : childNodes) {
            Loader.createFromPaneParams(node, this);
        }
    }

    @Override
    public void drawSelf(int mx, int my) {
        GlStateManager.func_179094_E();
        int paddedX = this.x + this.padding;
        int paddedY = this.y + this.padding;
        GlStateManager.func_179109_b((float)paddedX, (float)paddedY, (float)0.0f);
        int drawX = mx - paddedX;
        int drawY = my - paddedY;
        this.children.stream().filter(this::childIsVisible).forEach(child -> child.draw(drawX, drawY));
        GlStateManager.func_179121_F();
    }

    @Override
    public void scrollInput(int wheel) {
        for (Pane child : new ArrayList<Pane>(this.children)) {
            if (child == null) continue;
            child.scrollInput(wheel);
        }
    }

    @Override
    public void handleHover(int mx, int my) {
        for (Pane child : new ArrayList<Pane>(this.children)) {
            if (child == null) continue;
            child.handleHover(mx, my);
        }
    }

    @Override
    @Nullable
    public Pane findPaneByID(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        for (Pane child : this.children) {
            Pane found = child.findPaneByID(id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public void setWindow(Window w) {
        super.setWindow(w);
        for (Pane child : this.children) {
            child.setWindow(w);
        }
    }

    @Override
    public void rightClick(int mx, int my) {
        int mxChild = mx - this.x - this.padding;
        int myChild = my - this.y - this.padding;
        Pane clickedPane = this.findPaneForClick(mxChild, myChild);
        if (clickedPane != null) {
            clickedPane.rightClick(mxChild, myChild);
        } else {
            super.rightClick(mx, my);
        }
    }

    @Override
    public void click(int mx, int my) {
        int mxChild = mx - this.x - this.padding;
        int myChild = my - this.y - this.padding;
        Pane clickedPane = this.findPaneForClick(mxChild, myChild);
        if (clickedPane != null) {
            clickedPane.click(mxChild, myChild);
        } else {
            super.click(mx, my);
        }
    }

    @Nullable
    public Pane findPaneForClick(int mx, int my) {
        ListIterator<Pane> it = this.children.listIterator(this.children.size());
        while (it.hasPrevious()) {
            Pane child = it.previous();
            if (!child.canHandleClick(mx, my)) continue;
            return child;
        }
        return null;
    }

    @Override
    public void onUpdate() {
        this.children.forEach(Pane::onUpdate);
    }

    protected boolean childIsVisible(Pane child) {
        return child.getX() < this.getInteriorWidth() && child.getY() < this.getInteriorHeight() && child.getX() + child.getWidth() >= 0 && child.getY() + child.getHeight() >= 0;
    }

    public int getInteriorWidth() {
        return this.width - this.padding * 2;
    }

    public int getInteriorHeight() {
        return this.height - this.padding * 2;
    }

    public void addChild(Pane child) {
        child.setWindow(this.getWindow());
        this.children.add(child);
        this.adjustChild(child);
        child.setParentView(this);
    }

    protected void adjustChild(Pane child) {
        Alignment alignment;
        int childX = child.getX();
        int childY = child.getY();
        int childWidth = child.getWidth();
        int childHeight = child.getHeight();
        if (childWidth < 0) {
            childWidth = Math.max(0, this.getInteriorWidth() + childWidth);
        }
        if ((alignment = child.getAlignment()).isRightAligned()) {
            childX = this.getInteriorWidth() - childWidth - childX;
        } else if (alignment.isHorizontalCentered()) {
            childX = (this.getInteriorWidth() - childWidth) / 2 + childX;
        }
        if (childHeight < 0) {
            childHeight = Math.max(0, this.getInteriorHeight() + childHeight);
        }
        if (alignment.isBottomAligned()) {
            childY = this.getInteriorHeight() - childHeight - childY;
        } else if (alignment.isVerticalCentered()) {
            childY = (this.getInteriorHeight() - childHeight) / 2 + childY;
        }
        child.setSize(childWidth, childHeight);
        child.setPosition(childX, childY);
    }

    public void removeChild(Pane child) {
        this.children.remove((Object)child);
    }
}

